<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-12-26 00:36
 */
interface CurrencyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Currency 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param currency primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Currency currency
 	 */
	public function insert($currency);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Currency currency
 	 */
	public function update($currency);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryBySymbol($value);

	public function queryByConversionFactor($value);

	public function queryByConditions($value);

	public function queryByUserid($value);

	public function queryBySysDate($value);


	public function deleteByName($value);

	public function deleteBySymbol($value);

	public function deleteByConversionFactor($value);

	public function deleteByConditions($value);

	public function deleteByUserid($value);

	public function deleteBySysDate($value);


}
?>