<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:51
 */
interface IncomeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Income 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param income primary key
 	 */
	public function delete($incomeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Income income
 	 */
	public function insert($income);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Income income
 	 */
	public function update($income);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByIncomeTypeId($value);

	public function queryByIncomeName($value);

	public function queryByIncomeDetails($value);

	public function queryByIncomeValue($value);

	public function queryByIncomeDate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteByIncomeTypeId($value);

	public function deleteByIncomeName($value);

	public function deleteByIncomeDetails($value);

	public function deleteByIncomeValue($value);

	public function deleteByIncomeDate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>