<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
interface KashfDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Kashf 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param kashf primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Kashf kashf
 	 */
	public function insert($kashf);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Kashf kashf
 	 */
	public function update($kashf);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByKashfvalue($value);

	public function queryByKashftype($value);

	public function queryByCustomerid($value);

	public function queryByDoctorid($value);

	public function queryByKashfdate($value);

	public function queryByEntered($value);

	public function queryByPaystatus($value);


	public function deleteByKashfvalue($value);

	public function deleteByKashftype($value);

	public function deleteByCustomerid($value);

	public function deleteByDoctorid($value);

	public function deleteByKashfdate($value);

	public function deleteByEntered($value);

	public function deleteByPaystatus($value);


}
?>