<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-03-29 05:50
 */
interface LastbillidsquickprofitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Lastbillidsquickprofit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param lastbillidsquickprofit primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Lastbillidsquickprofit lastbillidsquickprofit
 	 */
	public function insert($lastbillidsquickprofit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Lastbillidsquickprofit lastbillidsquickprofit
 	 */
	public function update($lastbillidsquickprofit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySell($value);

	public function queryBySellDetail($value);

	public function queryBySellandret($value);

	public function queryBySellandretDetail($value);

	public function queryByRetsell($value);

	public function queryByRetsellDetail($value);


	public function deleteBySell($value);

	public function deleteBySellDetail($value);

	public function deleteBySellandret($value);

	public function deleteBySellandretDetail($value);

	public function deleteByRetsell($value);

	public function deleteByRetsellDetail($value);


}
?>