<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MComreceiptdetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MComreceiptdetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mComreceiptdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MComreceiptdetail mComreceiptdetail
 	 */
	public function insert($mComreceiptdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MComreceiptdetail mComreceiptdetail
 	 */
	public function update($mComreceiptdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReceiptid($value);

	public function queryByProductserial($value);

	public function queryByOurserial($value);

	public function queryByGranttype($value);

	public function queryBySellbillid($value);

	public function queryBySellbilldate($value);

	public function queryByBuybillid($value);

	public function queryByBuybilldate($value);

	public function queryByInsduration($value);

	public function queryByInsstatus($value);

	public function queryByProblem($value);

	public function queryByAttach($value);

	public function queryByComment($value);

	public function queryByShipcost($value);

	public function queryByInitialcost($value);

	public function queryBySupplierid($value);

	public function queryByCurrentstage($value);

	public function queryByBranchid($value);

	public function queryByDel($value);


	public function deleteByReceiptid($value);

	public function deleteByProductserial($value);

	public function deleteByOurserial($value);

	public function deleteByGranttype($value);

	public function deleteBySellbillid($value);

	public function deleteBySellbilldate($value);

	public function deleteByBuybillid($value);

	public function deleteByBuybilldate($value);

	public function deleteByInsduration($value);

	public function deleteByInsstatus($value);

	public function deleteByProblem($value);

	public function deleteByAttach($value);

	public function deleteByComment($value);

	public function deleteByShipcost($value);

	public function deleteByInitialcost($value);

	public function deleteBySupplierid($value);

	public function deleteByCurrentstage($value);

	public function deleteByBranchid($value);

	public function deleteByDel($value);


}
?>