<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface MovementmanageDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Movementmanage 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param movementmanage primary key
 	 */
	public function delete($movementmanageid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Movementmanage movementmanage
 	 */
	public function insert($movementmanage);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Movementmanage movementmanage
 	 */
	public function update($movementmanage);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOperationname($value);

	public function queryByMovementmanagedate($value);

	public function queryByUserid($value);


	public function deleteByOperationname($value);

	public function deleteByMovementmanagedate($value);

	public function deleteByUserid($value);


}
?>