<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-07-08 15:56
 */
interface MovementmanagedeletedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Movementmanagedeleted 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param movementmanagedeleted primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Movementmanagedeleted movementmanagedeleted
 	 */
	public function insert($movementmanagedeleted);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Movementmanagedeleted movementmanagedeleted
 	 */
	public function update($movementmanagedeleted);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOperationname($value);

	public function queryByMovementmanagedate($value);

	public function queryByUserid($value);

	public function queryByCurrentDo($value);


	public function deleteByOperationname($value);

	public function deleteByMovementmanagedate($value);

	public function deleteByUserid($value);

	public function deleteByCurrentDo($value);


}
?>