<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-16 10:42
 */
interface OnlinetempcategoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetempcategory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetempcategory primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetempcategory onlinetempcategory
 	 */
	public function insert($onlinetempcategory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetempcategory onlinetempcategory
 	 */
	public function update($onlinetempcategory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCatid($value);

	public function queryByEdited($value);

	public function queryBySysdate($value);

	public function queryByUserid($value);


	public function deleteByCatid($value);

	public function deleteByEdited($value);

	public function deleteBySysdate($value);

	public function deleteByUserid($value);


}
?>