<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ProductcatDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productcat 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productcat primary key
 	 */
	public function delete($productCatId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productcat productcat
 	 */
	public function insert($productcat);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productcat productcat
 	 */
	public function update($productcat);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductCatName($value);

	public function queryByProductCatDate($value);

	public function queryByProductCatDescription($value);

	public function queryByProductCatParent($value);

	public function queryByUserId($value);

	public function queryByCondition($value);


	public function deleteByProductCatName($value);

	public function deleteByProductCatDate($value);

	public function deleteByProductCatDescription($value);

	public function deleteByProductCatParent($value);

	public function deleteByUserId($value);

	public function deleteByCondition($value);


}
?>