<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
interface ProductionoutmanyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionoutmany 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionoutmany primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionoutmany productionoutmany
 	 */
	public function insert($productionoutmany);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionoutmany productionoutmany
 	 */
	public function update($productionoutmany);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOutStore($value);

	public function queryByInStore($value);

	public function queryBySupplier($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryBySysDate($value);

	public function queryByDel($value);


	public function deleteByOutStore($value);

	public function deleteByInStore($value);

	public function deleteBySupplier($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteBySysDate($value);

	public function deleteByDel($value);


}
?>