<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface ProductionrateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionrate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionrate primary key
 	 */
	public function delete($productionRateId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionrate productionrate
 	 */
	public function insert($productionrate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionrate productionrate
 	 */
	public function update($productionrate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByUserId($value);

	public function queryByTheDate($value);

	public function queryByConditions($value);


	public function deleteByName($value);

	public function deleteByUserId($value);

	public function deleteByTheDate($value);

	public function deleteByConditions($value);


}
?>