<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:38
 */
interface RestauranttableDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restauranttable 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restauranttable primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restauranttable restauranttable
 	 */
	public function insert($restauranttable);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restauranttable restauranttable
 	 */
	public function update($restauranttable);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByHallid($value);

	public function queryByName($value);

	public function queryByBeingUsed($value);

	public function queryByUserId($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByHallid($value);

	public function deleteByName($value);

	public function deleteByBeingUsed($value);

	public function deleteByUserId($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>