<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface StoredetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Storedetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param storedetail primary key
 	 */
	public function delete($storedetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Storedetail storedetail
 	 */
	public function insert($storedetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Storedetail storedetail
 	 */
	public function update($storedetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByStoreid($value);

	public function queryByProductquantity($value);

	public function queryByUserid($value);

	public function queryByStoredetaildate($value);


	public function deleteByProductid($value);

	public function deleteByStoreid($value);

	public function deleteByProductquantity($value);

	public function deleteByUserid($value);

	public function deleteByStoredetaildate($value);


}
?>