<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface StorereportDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Storereport 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param storereport primary key
 	 */
	public function delete($storereportid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Storereport storereport
 	 */
	public function insert($storereport);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Storereport storereport
 	 */
	public function update($storereport);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByStoreid($value);

	public function queryByProductquantity($value);

	public function queryByStorereporttype($value);

	public function queryByStorereportmodelid($value);

	public function queryByProcessname($value);

	public function queryByTablename($value);

	public function queryByProductbefore($value);

	public function queryByProductafter($value);

	public function queryByUserid($value);

	public function queryByStorereportdate($value);


	public function deleteByProductid($value);

	public function deleteByStoreid($value);

	public function deleteByProductquantity($value);

	public function deleteByStorereporttype($value);

	public function deleteByStorereportmodelid($value);

	public function deleteByProcessname($value);

	public function deleteByTablename($value);

	public function deleteByProductbefore($value);

	public function deleteByProductafter($value);

	public function deleteByUserid($value);

	public function deleteByStorereportdate($value);


}
?>