<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface SupplierdebtchangeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supplierdebtchange 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supplierdebtchange primary key
 	 */
	public function delete($supplierdebtchangeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supplierdebtchange supplierdebtchange
 	 */
	public function insert($supplierdebtchange);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supplierdebtchange supplierdebtchange
 	 */
	public function update($supplierdebtchange);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySupplierdebtchangebefore($value);

	public function queryBySupplierdebtchangeamount($value);

	public function queryBySupplierdebtchangetype($value);

	public function queryByProcessname($value);

	public function queryBySupplierdebtchangemodelid($value);

	public function queryBySupplierdebtchangeafter($value);

	public function queryBySupplierdebtchangedate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);


	public function deleteBySupplierdebtchangebefore($value);

	public function deleteBySupplierdebtchangeamount($value);

	public function deleteBySupplierdebtchangetype($value);

	public function deleteByProcessname($value);

	public function deleteBySupplierdebtchangemodelid($value);

	public function deleteBySupplierdebtchangeafter($value);

	public function deleteBySupplierdebtchangedate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);


}
?>