<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-21 13:00
 */
interface SupplieropenexchangeorclosingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supplieropenexchangeorclosing 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supplieropenexchangeorclosing primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supplieropenexchangeorclosing supplieropenexchangeorclosing
 	 */
	public function insert($supplieropenexchangeorclosing);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supplieropenexchangeorclosing supplieropenexchangeorclosing
 	 */
	public function update($supplieropenexchangeorclosing);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByThetype($value);

	public function queryBySupplieropenid($value);

	public function queryBySaveid($value);

	public function queryByAssetorexpense($value);

	public function queryByAssetorexpenseid($value);

	public function queryByVal($value);

	public function queryByDailyentryid($value);

	public function queryByNote($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByThetype($value);

	public function deleteBySupplieropenid($value);

	public function deleteBySaveid($value);

	public function deleteByAssetorexpense($value);

	public function deleteByAssetorexpenseid($value);

	public function deleteByVal($value);

	public function deleteByDailyentryid($value);

	public function deleteByNote($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>