<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface UnitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Unit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param unit primary key
 	 */
	public function delete($unitId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Unit unit
 	 */
	public function insert($unit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Unit unit
 	 */
	public function update($unit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUnitName($value);

	public function queryByUnitDescription($value);

	public function queryByUnitDate($value);

	public function queryByCondition($value);

	public function queryByUserId($value);


	public function deleteByUnitName($value);

	public function deleteByUnitDescription($value);

	public function deleteByUnitDate($value);

	public function deleteByCondition($value);

	public function deleteByUserId($value);


}
?>