<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface WorkstationDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Workstation 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param workstation primary key
 	 */
	public function delete($workstationid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Workstation workstation
 	 */
	public function insert($workstation);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Workstation workstation
 	 */
	public function update($workstation);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByWorkname($value);

	public function queryByWorkerhours($value);

	public function queryByAssetshours($value);

	public function queryByEfficiency($value);

	public function queryByDate($value);

	public function queryByCondition($value);

	public function queryByUserId($value);


	public function deleteByWorkname($value);

	public function deleteByWorkerhours($value);

	public function deleteByAssetshours($value);

	public function deleteByEfficiency($value);

	public function deleteByDate($value);

	public function deleteByCondition($value);

	public function deleteByUserId($value);


}
?>