<?php

/**
 * Class that operate on table 'billsproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
class BillsproductsMySqlDAO implements BillsproductsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsproductsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsproducts WHERE id = ' . $id;
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsproducts ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billsproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsproductsMySql billsproduct
     */
    public function insert($billsproduct) {
        $sql = 'INSERT INTO billsproducts (billid, productid, note, productno, productprice, producttotalprice, deleted, service , retproductno , rondomtxt,lastbuyprice,meanbuyprice,storeid,productcode) VALUES (? , ? ,?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsproduct->billid);
        $sqlQuery->setNumber($billsproduct->productid);
        $sqlQuery->set($billsproduct->note);
        $sqlQuery->setNumber($billsproduct->productno);
        $sqlQuery->set($billsproduct->productprice);
        $sqlQuery->set($billsproduct->producttotalprice);
        $sqlQuery->setNumber($billsproduct->deleted);
        $sqlQuery->set($billsproduct->service);
        $sqlQuery->setNumber($billsproduct->retproductno);
        $sqlQuery->set($billsproduct->rondomtxt);

        $sqlQuery->set($billsproduct->lastbuyprice);
        $sqlQuery->set($billsproduct->meanbuyprice);
        $sqlQuery->setNumber($billsproduct->storeid);
        $sqlQuery->set($billsproduct->productcode);



        $id = $this->executeInsert($sqlQuery);
        $billsproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsproductsMySql billsproduct
     */
    public function update($billsproduct) {
        $sql = 'UPDATE billsproducts SET billid = ?, productid = ?, note = ?, productno = ?, productprice = ?, producttotalprice = ?, deleted = ?, service = ? , retproductno = ? , rondomtxt = ?,lastbuyprice = ?,meanbuyprice = ?,storeid = ?.productcode = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsproduct->billid);
        $sqlQuery->setNumber($billsproduct->productid);
        $sqlQuery->set($billsproduct->note);
        $sqlQuery->setNumber($billsproduct->productno);
        $sqlQuery->set($billsproduct->productprice);
        $sqlQuery->set($billsproduct->producttotalprice);
        $sqlQuery->setNumber($billsproduct->deleted);
        $sqlQuery->set($billsproduct->service);
        $sqlQuery->setNumber($billsproduct->retproductno);
        $sqlQuery->set($billsproduct->rondomtxt);

        $sqlQuery->set($billsproduct->lastbuyprice);
        $sqlQuery->set($billsproduct->meanbuyprice);
        $sqlQuery->setNumber($billsproduct->storeid);
        $sqlQuery->set($billsproduct->productcode);


        $sqlQuery->setNumber($billsproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM billsproducts WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM billsproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM billsproducts WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductno($value) {
        $sql = 'SELECT * FROM billsproducts WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductprice($value) {
        $sql = 'SELECT * FROM billsproducts WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProducttotalprice($value) {
        $sql = 'SELECT * FROM billsproducts WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM billsproducts WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByService($value) {
        $sql = 'SELECT * FROM billsproducts WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM billsproducts WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM billsproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM billsproducts WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductno($value) {
        $sql = 'DELETE FROM billsproducts WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductprice($value) {
        $sql = 'DELETE FROM billsproducts WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProducttotalprice($value) {
        $sql = 'DELETE FROM billsproducts WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM billsproducts WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByService($value) {
        $sql = 'DELETE FROM billsproducts WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsproductsMySql
     */
    protected function readRow($row) {
        $billsproduct = new Billsproduct();

        $billsproduct->id = isset($row['id']) ? $row['id'] : '';
        $billsproduct->billid = isset($row['billid']) ? $row['billid'] : '';
        $billsproduct->productid = isset($row['productid']) ? $row['productid'] : '';
        $billsproduct->note = isset($row['note']) ? $row['note'] : '';
        $billsproduct->productno = isset($row['productno']) ? $row['productno'] : '';
        $billsproduct->productprice = isset($row['productprice']) ? $row['productprice'] : '';
        $billsproduct->producttotalprice = isset($row['producttotalprice']) ? $row['producttotalprice'] : '';
        $billsproduct->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $billsproduct->service = isset($row['service']) ? $row['service'] : '';
        $billsproduct->retproductno = isset($row['retproductno']) ? $row['retproductno'] : '';
        $billsproduct->netproductno = isset($row['netproductno']) ? $row['netproductno'] : '';
        $billsproduct->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';
        $billsproduct->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        #################
        $billsproduct->productName = isset($row['productName']) ? $row['productName'] : '';
        $billsproduct->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $billsproduct->productcode = isset($row['productcode']) ? $row['productcode'] : '';
        $billsproduct->retno = isset($row['retno']) ? $row['retno'] : '';
        $billsproduct->retprice = isset($row['retprice']) ? $row['retprice'] : '';
        $billsproduct->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $billsproduct->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $billsproduct->billtype = isset($row['billtype']) ? $row['billtype'] : '';


        $billsproduct->finalnetbillvalue = isset($row['finalnetbillvalue']) ? $row['finalnetbillvalue'] : '';
        $billsproduct->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';

        $billsproduct->netbillvalue = isset($row['netbillvalue']) ? $row['netbillvalue'] : '';
        $billsproduct->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $billsproduct->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $billsproduct->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $billsproduct->clientid = isset($row['clientid']) ? $row['clientid'] : '';

        $billsproduct->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $billsproduct->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $billsproduct->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        return $billsproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsproductsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>