<?php

/**
 * Class that operate on table 'capital'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class CapitalMySqlDAO implements CapitalDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CapitalMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM capital WHERE capitalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM capital';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM capital ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param capital primary key
     */
    public function delete($capitalid) {
        $sql = 'DELETE FROM capital WHERE capitalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($capitalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CapitalMySql capital
     */
    public function insert($capital) {
        $sql = 'INSERT INTO capital (capitalamount,treeId) VALUES (?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($capital->capitalamount);
        $sqlQuery->setNumber((int) $capital->treeId);

        $id = $this->executeInsert($sqlQuery);
        $capital->capitalid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CapitalMySql capital
     */
    public function update($capital) {
        $sql = 'UPDATE capital SET capitalamount = ?,treeId=? WHERE capitalid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($capital->capitalamount);
        $sqlQuery->setNumber((int) $capital->treeId);

        $sqlQuery->setNumber($capital->capitalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM capital';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCapitalamount($value) {
        $sql = 'SELECT * FROM capital WHERE capitalamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCapitalamount($value) {
        $sql = 'DELETE FROM capital WHERE capitalamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CapitalMySql
     */
    protected function readRow($row) {
        $capital = new Capital();

        $capital->capitalid = isset($row['capitalid']) ? $row['capitalid'] : '';
        $capital->capitalamount = isset($row['capitalamount']) ? $row['capitalamount'] : '';
        $capital->treeId = isset($row['treeId']) ? $row['treeId'] : '';

        return $capital;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CapitalMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>