<?php

/**
 * Class that operate on table 'complementpurchasebill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class ComplementpurchasebillMySqlDAO implements ComplementpurchasebillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ComplementpurchasebillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE complementpurchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM complementpurchasebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM complementpurchasebill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param complementpurchasebill primary key
     */
    public function delete($complementpurchasebillid) {
        $sql = 'DELETE FROM complementpurchasebill WHERE complementpurchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($complementpurchasebillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ComplementpurchasebillMySql complementpurchasebill
     */
    public function insert($complementpurchasebill) {
        $sql = 'INSERT INTO complementpurchasebill (rawmaterialid, rawmaterialprice, rawmaterialamount, rawmaterialdisount, complementpurchasebilltotal) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($complementpurchasebill->rawmaterialid);
        $sqlQuery->set($complementpurchasebill->rawmaterialprice);
        $sqlQuery->set($complementpurchasebill->rawmaterialamount);
        $sqlQuery->set($complementpurchasebill->rawmaterialdisount);
        $sqlQuery->set($complementpurchasebill->complementpurchasebilltotal);

        $id = $this->executeInsert($sqlQuery);
        $complementpurchasebill->complementpurchasebillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ComplementpurchasebillMySql complementpurchasebill
     */
    public function update($complementpurchasebill) {
        $sql = 'UPDATE complementpurchasebill SET rawmaterialid = ?, rawmaterialprice = ?, rawmaterialamount = ?, rawmaterialdisount = ?, complementpurchasebilltotal = ? WHERE complementpurchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($complementpurchasebill->rawmaterialid);
        $sqlQuery->set($complementpurchasebill->rawmaterialprice);
        $sqlQuery->set($complementpurchasebill->rawmaterialamount);
        $sqlQuery->set($complementpurchasebill->rawmaterialdisount);
        $sqlQuery->set($complementpurchasebill->complementpurchasebilltotal);

        $sqlQuery->setNumber($complementpurchasebill->complementpurchasebillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM complementpurchasebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialid($value) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialprice($value) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialamount($value) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE rawmaterialamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialdisount($value) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE rawmaterialdisount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComplementpurchasebilltotal($value) {
        $sql = 'SELECT * FROM complementpurchasebill WHERE complementpurchasebilltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialid($value) {
        $sql = 'DELETE FROM complementpurchasebill WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialprice($value) {
        $sql = 'DELETE FROM complementpurchasebill WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialamount($value) {
        $sql = 'DELETE FROM complementpurchasebill WHERE rawmaterialamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialdisount($value) {
        $sql = 'DELETE FROM complementpurchasebill WHERE rawmaterialdisount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComplementpurchasebilltotal($value) {
        $sql = 'DELETE FROM complementpurchasebill WHERE complementpurchasebilltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ComplementpurchasebillMySql
     */
    protected function readRow($row) {
        $complementpurchasebill = new Complementpurchasebill();

        $complementpurchasebill->complementpurchasebillid = isset($row['complementpurchasebillid']) ? $row['complementpurchasebillid'] : '';
        $complementpurchasebill->rawmaterialid = isset($row['rawmaterialid']) ? $row['rawmaterialid'] : '';
        $complementpurchasebill->rawmaterialprice = isset($row['rawmaterialprice']) ? $row['rawmaterialprice'] : '';
        $complementpurchasebill->rawmaterialamount = isset($row['rawmaterialamount']) ? $row['rawmaterialamount'] : '';
        $complementpurchasebill->rawmaterialdisount = isset($row['rawmaterialdisount']) ? $row['rawmaterialdisount'] : '';
        $complementpurchasebill->complementpurchasebilltotal = isset($row['complementpurchasebilltotal']) ? $row['complementpurchasebilltotal'] : '';

        return $complementpurchasebill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ComplementpurchasebillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>