<?php

/**
 * Class that operate on table 'damagedproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 17:33
 */
class DamagedproductMySqlDAO implements DamagedproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DamagedproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM damagedproduct WHERE damagedProductId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM damagedproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM damagedproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param damagedproduct primary key
     */
    public function delete($damagedProductId) {
        $sql = 'DELETE FROM damagedproduct WHERE damagedProductId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($damagedProductId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DamagedproductMySql damagedproduct
     */
    public function insert($damagedproduct) {
        $sql = 'INSERT INTO damagedproduct (productId, measurUnitId, productQuantity, cost, productionOrderId, operationDate, userID, storeId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($damagedproduct->productId);
        $sqlQuery->setNumber($damagedproduct->measurUnitId);
        $sqlQuery->setNumber($damagedproduct->productQuantity);
        $sqlQuery->setNumber($damagedproduct->cost);
        $sqlQuery->setNumber($damagedproduct->productionOrderId);
        $sqlQuery->set($damagedproduct->operationDate);
        $sqlQuery->setNumber($damagedproduct->userID);
        $sqlQuery->setNumber($damagedproduct->storeId);

        $id = $this->executeInsert($sqlQuery);
        $damagedproduct->damagedProductId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DamagedproductMySql damagedproduct
     */
    public function update($damagedproduct) {
        $sql = 'UPDATE damagedproduct SET productId = ?, measurUnitId = ?, productQuantity = ?, cost = ?, productionOrderId = ?, operationDate = ?, userID = ?, storeId = ? WHERE damagedProductId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($damagedproduct->productId);
        $sqlQuery->setNumber($damagedproduct->measurUnitId);
        $sqlQuery->setNumber($damagedproduct->productQuantity);
        $sqlQuery->setNumber($damagedproduct->cost);
        $sqlQuery->setNumber($damagedproduct->productionOrderId);
        $sqlQuery->set($damagedproduct->operationDate);
        $sqlQuery->setNumber($damagedproduct->userID);
        $sqlQuery->setNumber($damagedproduct->storeId);

        $sqlQuery->setNumber($damagedproduct->damagedProductId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM damagedproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeasurUnitId($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE measurUnitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductQuantity($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE productQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCost($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductionOrderId($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE productionOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperationDate($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserID($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreId($value) {
        $sql = 'SELECT * FROM damagedproduct WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM damagedproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeasurUnitId($value) {
        $sql = 'DELETE FROM damagedproduct WHERE measurUnitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductQuantity($value) {
        $sql = 'DELETE FROM damagedproduct WHERE productQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCost($value) {
        $sql = 'DELETE FROM damagedproduct WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductionOrderId($value) {
        $sql = 'DELETE FROM damagedproduct WHERE productionOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperationDate($value) {
        $sql = 'DELETE FROM damagedproduct WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserID($value) {
        $sql = 'DELETE FROM damagedproduct WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreId($value) {
        $sql = 'DELETE FROM damagedproduct WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DamagedproductMySql
     */
    protected function readRow($row) {
        $damagedproduct = new Damagedproduct();

        $damagedproduct->damagedProductId = isset($row['damagedProductId']) ? $row['damagedProductId'] : '';
        $damagedproduct->productId = isset($row['productId']) ? $row['productId'] : '';
        $damagedproduct->measurUnitId = isset($row['measurUnitId']) ? $row['measurUnitId'] : '';
        $damagedproduct->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $damagedproduct->productQuantity = isset($row['productQuantity']) ? $row['productQuantity'] : '';
        $damagedproduct->cost = isset($row['cost']) ? $row['cost'] : '';
        $damagedproduct->productionOrderId = isset($row['productionOrderId']) ? $row['productionOrderId'] : '';
        $damagedproduct->operationDate = isset($row['operationDate']) ? $row['operationDate'] : '';
        $damagedproduct->userID = isset($row['userID']) ? $row['userID'] : '';
        $damagedproduct->storeId = isset($row['storeId']) ? $row['storeId'] : '';
        $damagedproduct->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $damagedproduct->productName = isset($row['productName']) ? $row['productName'] : '';
        $damagedproduct->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';


        return $damagedproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DamagedproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>