<?php
/**
 * Class that operate on table 'employeeclosedaystatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-19 05:41
 */
class EmployeeclosedaystatusMySqlDAO implements EmployeeclosedaystatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EmployeeclosedaystatusMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM employeeclosedaystatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM employeeclosedaystatus ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedaystatu primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EmployeeclosedaystatusMySql employeeclosedaystatu
 	 */
	public function insert($employeeclosedaystatu){
		$sql = 'INSERT INTO employeeclosedaystatus (day, status, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaystatu->day);
		$sqlQuery->setNumber($employeeclosedaystatu->status);
		$sqlQuery->setNumber($employeeclosedaystatu->userid);
		$sqlQuery->set($employeeclosedaystatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaystatu->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$employeeclosedaystatu->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EmployeeclosedaystatusMySql employeeclosedaystatu
 	 */
	public function update($employeeclosedaystatu){
		$sql = 'UPDATE employeeclosedaystatus SET day = ?, status = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaystatu->day);
		$sqlQuery->setNumber($employeeclosedaystatu->status);
		$sqlQuery->setNumber($employeeclosedaystatu->userid);
		$sqlQuery->set($employeeclosedaystatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaystatu->conditions);

		$sqlQuery->setNumber($employeeclosedaystatu->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM employeeclosedaystatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDay($value){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM employeeclosedaystatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDay($value){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM employeeclosedaystatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EmployeeclosedaystatusMySql 
	 */
	protected function readRow($row){
		$employeeclosedaystatu = new Employeeclosedaystatu();
		
		$employeeclosedaystatu->id = $row['id'];
		$employeeclosedaystatu->day = $row['day'];
		$employeeclosedaystatu->status = $row['status'];
		$employeeclosedaystatu->userid = $row['userid'];
		$employeeclosedaystatu->sysdate = $row['sysdate'];
		$employeeclosedaystatu->conditions = $row['conditions'];

		return $employeeclosedaystatu;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EmployeeclosedaystatusMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>