<?php

/**
 * Class that operate on table 'm_check'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MCheckMySqlDAO implements MCheckDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MCheckMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_check WHERE checkId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_check';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_check ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mCheck primary key
     */
    public function delete($checkId) {
        $sql = 'DELETE FROM m_check WHERE checkId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($checkId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MCheckMySql mCheck
     */
    public function insert($mCheck) {
        $sql = 'INSERT INTO m_check (ourSerial, userId, stageFrom, checkDate, branchId, del) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mCheck->ourSerial);
        $sqlQuery->setNumber($mCheck->userId);
        $sqlQuery->setNumber($mCheck->stageFrom);
        $sqlQuery->set($mCheck->checkDate);
        $sqlQuery->setNumber($mCheck->branchId);
        $sqlQuery->setNumber($mCheck->del);

        $id = $this->executeInsert($sqlQuery);
        $mCheck->checkId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MCheckMySql mCheck
     */
    public function update($mCheck) {
        $sql = 'UPDATE m_check SET ourSerial = ?, userId = ?, stageFrom = ?, checkDate = ?, branchId = ?, del = ? WHERE checkId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mCheck->ourSerial);
        $sqlQuery->setNumber($mCheck->userId);
        $sqlQuery->setNumber($mCheck->stageFrom);
        $sqlQuery->set($mCheck->checkDate);
        $sqlQuery->setNumber($mCheck->branchId);
        $sqlQuery->setNumber($mCheck->del);

        $sqlQuery->setNumber($mCheck->checkId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_check';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_check WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_check WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageFrom($value) {
        $sql = 'SELECT * FROM m_check WHERE stageFrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckDate($value) {
        $sql = 'SELECT * FROM m_check WHERE checkDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_check WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_check WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_check WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_check WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageFrom($value) {
        $sql = 'DELETE FROM m_check WHERE stageFrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckDate($value) {
        $sql = 'DELETE FROM m_check WHERE checkDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_check WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_check WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MCheckMySql
     */
    protected function readRow($row) {
        $mCheck = new MCheck();

        $mCheck->checkId = isset($row['checkId']) ? $row['checkId'] : '';
        $mCheck->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mCheck->userId = isset($row['userId']) ? $row['userId'] : '';
        $mCheck->stageFrom = isset($row['stageFrom']) ? $row['stageFrom'] : '';
        $mCheck->checkDate = isset($row['checkDate']) ? $row['checkDate'] : '';
        $mCheck->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mCheck->del = isset($row['del']) ? $row['del'] : '';

        $mCheck->m_stageTitle = isset($row['m_stageTitle']) ? $row['m_stageTitle'] : '';
        $mCheck->receiptserial = isset($row['receiptserial']) ? $row['receiptserial'] : '';
        $mCheck->productserial = isset($row['productserial']) ? $row['productserial'] : '';
        $mCheck->productId = isset($row['productId']) ? $row['productId'] : '';
        $mCheck->productName = isset($row['productName']) ? $row['productName'] : '';
        $mCheck->granttype = isset($row['granttype']) ? $row['granttype'] : '';
        $mCheck->productHistoryStatus = isset($row['productHistoryStatus']) ? $row['productHistoryStatus'] : '';
        $mCheck->initialcost = isset($row['initialcost']) ? $row['initialcost'] : '';
        $mCheck->id = isset($row['id']) ? $row['id'] : '';
        $mCheck->clientname = isset($row['clientname']) ? $row['clientname'] : '';

        $mCheck->problem = isset($row['problem']) ? $row['problem'] : '';
        $mCheck->comment = isset($row['comment']) ? $row['comment'] : '';

        return $mCheck;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MCheckMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>