<?php

/**
 * Class that operate on table 'm_comreceiptimage'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MComreceiptimageMySqlDAO implements MComreceiptimageDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MComreceiptimageMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_comreceiptimage WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_comreceiptimage';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_comreceiptimage ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mComreceiptimage primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM m_comreceiptimage WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MComreceiptimageMySql mComreceiptimage
     */
    public function insert($mComreceiptimage) {
        $sql = 'INSERT INTO m_comreceiptimage (comreceiptid, receiptimage, imagedate, userid) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mComreceiptimage->comreceiptid);
        $sqlQuery->set($mComreceiptimage->receiptimage);
        $sqlQuery->set($mComreceiptimage->imagedate);
        $sqlQuery->setNumber($mComreceiptimage->userid);

        $id = $this->executeInsert($sqlQuery);
        $mComreceiptimage->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MComreceiptimageMySql mComreceiptimage
     */
    public function update($mComreceiptimage) {
        $sql = 'UPDATE m_comreceiptimage SET comreceiptid = ?, receiptimage = ?, imagedate = ?, userid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mComreceiptimage->comreceiptid);
        $sqlQuery->set($mComreceiptimage->receiptimage);
        $sqlQuery->set($mComreceiptimage->imagedate);
        $sqlQuery->setNumber($mComreceiptimage->userid);

        $sqlQuery->setNumber($mComreceiptimage->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_comreceiptimage';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByComreceiptid($value) {
        $sql = 'SELECT * FROM m_comreceiptimage WHERE comreceiptid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReceiptimage($value) {
        $sql = 'SELECT * FROM m_comreceiptimage WHERE receiptimage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImagedate($value) {
        $sql = 'SELECT * FROM m_comreceiptimage WHERE imagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM m_comreceiptimage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByComreceiptid($value) {
        $sql = 'DELETE FROM m_comreceiptimage WHERE comreceiptid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReceiptimage($value) {
        $sql = 'DELETE FROM m_comreceiptimage WHERE receiptimage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImagedate($value) {
        $sql = 'DELETE FROM m_comreceiptimage WHERE imagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM m_comreceiptimage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MComreceiptimageMySql
     */
    protected function readRow($row) {
        $mComreceiptimage = new MComreceiptimage();

        $mComreceiptimage->id = isset($row['id']) ? $row['id'] : '';
        $mComreceiptimage->comreceiptid = isset($row['comreceiptid']) ? $row['comreceiptid'] : '';
        $mComreceiptimage->receiptimage = isset($row['receiptimage']) ? $row['receiptimage'] : '';
        $mComreceiptimage->imagedate = isset($row['imagedate']) ? $row['imagedate'] : '';
        $mComreceiptimage->userid = isset($row['userid']) ? $row['userid'] : '';

        return $mComreceiptimage;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MComreceiptimageMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>