<?php

/**
 * Class that operate on table 'onlinetempcategory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-16 10:42
 */
class OnlinetempcategoryMySqlDAO implements OnlinetempcategoryDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OnlinetempcategoryMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM onlinetempcategory WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM onlinetempcategory';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM onlinetempcategory ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param onlinetempcategory primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM onlinetempcategory WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OnlinetempcategoryMySql onlinetempcategory
     */
    public function insert($onlinetempcategory) {
        $sql = 'INSERT INTO onlinetempcategory (catid, edited, sysdate, userid) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetempcategory->catid);
        $sqlQuery->setNumber($onlinetempcategory->edited);
        $sqlQuery->set($onlinetempcategory->sysdate);
        $sqlQuery->setNumber($onlinetempcategory->userid);

        $id = $this->executeInsert($sqlQuery);
        $onlinetempcategory->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OnlinetempcategoryMySql onlinetempcategory
     */
    public function update($onlinetempcategory) {
        $sql = 'UPDATE onlinetempcategory SET catid = ?, edited = ?, sysdate = ?, userid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetempcategory->catid);
        $sqlQuery->setNumber($onlinetempcategory->edited);
        $sqlQuery->set($onlinetempcategory->sysdate);
        $sqlQuery->setNumber($onlinetempcategory->userid);

        $sqlQuery->setNumber($onlinetempcategory->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM onlinetempcategory';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCatid($value) {
        $sql = 'SELECT * FROM onlinetempcategory WHERE catid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEdited($value) {
        $sql = 'SELECT * FROM onlinetempcategory WHERE edited = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM onlinetempcategory WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM onlinetempcategory WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCatid($value) {
        $sql = 'DELETE FROM onlinetempcategory WHERE catid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEdited($value) {
        $sql = 'DELETE FROM onlinetempcategory WHERE edited = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM onlinetempcategory WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM onlinetempcategory WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OnlinetempcategoryMySql
     */
    protected function readRow($row) {
        $onlinetempcategory = new Onlinetempcategory();

        $onlinetempcategory->id = $row['id'];
        $onlinetempcategory->catid = $row['catid'];
        $onlinetempcategory->edited = $row['edited'];
        $onlinetempcategory->sysdate = $row['sysdate'];
        $onlinetempcategory->userid = $row['userid'];

        return $onlinetempcategory;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OnlinetempcategoryMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>