<?php
/**
 * Class that operate on table 'premiumautomatic'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-04-23 00:00
 */
class PremiumautomaticMySqlDAO implements PremiumautomaticDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PremiumautomaticMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM premiumautomatic WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM premiumautomatic';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM premiumautomatic ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param premiumautomatic primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM premiumautomatic WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PremiumautomaticMySql premiumautomatic
 	 */
	public function insert($premiumautomatic){
		$sql = 'INSERT INTO premiumautomatic (Totalinstallment, presenter_dir, presenter_per, date, remain_amount, installment_nos, installment_months, installment_days, client_id, userid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premiumautomatic->totalinstallment);
		$sqlQuery->set($premiumautomatic->presenterDir);
		$sqlQuery->set($premiumautomatic->presenterPer);
		$sqlQuery->set($premiumautomatic->date);
		$sqlQuery->set($premiumautomatic->remainAmount);
		$sqlQuery->set($premiumautomatic->installmentNos);
		$sqlQuery->set($premiumautomatic->installmentMonths);
		$sqlQuery->set($premiumautomatic->installmentDays);
		$sqlQuery->set($premiumautomatic->clientId);
		$sqlQuery->set($premiumautomatic->userid);
		$id = $this->executeInsert($sqlQuery);
		$premiumautomatic->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PremiumautomaticMySql premiumautomatic
 	 */
	public function update($premiumautomatic){
		$sql = 'UPDATE premiumautomatic SET Totalinstallment = ?, presenter_dir = ?, presenter_per = ?, date = ?, remain_amount = ?, installment_nos = ?, installment_months = ?, installment_days = ?, client_id = ?, userid = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premiumautomatic->totalinstallment);
		$sqlQuery->set($premiumautomatic->presenterDir);
		$sqlQuery->set($premiumautomatic->presenterPer);
		$sqlQuery->set($premiumautomatic->date);
		$sqlQuery->set($premiumautomatic->remainAmount);
		$sqlQuery->set($premiumautomatic->installmentNos);
		$sqlQuery->set($premiumautomatic->installmentMonths);
		$sqlQuery->set($premiumautomatic->installmentDays);
		$sqlQuery->set($premiumautomatic->clientId);
		$sqlQuery->set($premiumautomatic->userid);

		$sqlQuery->setNumber($premiumautomatic->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM premiumautomatic';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTotalinstallment($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE Totalinstallment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPresenterDir($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE presenter_dir = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPresenterPer($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE presenter_per = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemainAmount($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE remain_amount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByInstallmentNos($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE installment_nos = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByInstallmentMonths($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE installment_months = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByInstallmentDays($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE installment_days = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM premiumautomatic WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTotalinstallment($value){
		$sql = 'DELETE FROM premiumautomatic WHERE Totalinstallment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPresenterDir($value){
		$sql = 'DELETE FROM premiumautomatic WHERE presenter_dir = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPresenterPer($value){
		$sql = 'DELETE FROM premiumautomatic WHERE presenter_per = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM premiumautomatic WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemainAmount($value){
		$sql = 'DELETE FROM premiumautomatic WHERE remain_amount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByInstallmentNos($value){
		$sql = 'DELETE FROM premiumautomatic WHERE installment_nos = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByInstallmentMonths($value){
		$sql = 'DELETE FROM premiumautomatic WHERE installment_months = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByInstallmentDays($value){
		$sql = 'DELETE FROM premiumautomatic WHERE installment_days = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientId($value){
		$sql = 'DELETE FROM premiumautomatic WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM premiumautomatic WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PremiumautomaticMySql 
	 */
	protected function readRow($row){
		$premiumautomatic = new Premiumautomatic();
		
		$premiumautomatic->id = $row['id'];
		$premiumautomatic->totalinstallment = $row['Totalinstallment'];
		$premiumautomatic->presenterDir = $row['presenter_dir'];
		$premiumautomatic->presenterPer = $row['presenter_per'];
		$premiumautomatic->date = $row['date'];
		$premiumautomatic->remainAmount = $row['remain_amount'];
		$premiumautomatic->installmentNos = $row['installment_nos'];
		$premiumautomatic->installmentMonths = $row['installment_months'];
		$premiumautomatic->installmentDays = $row['installment_days'];
		$premiumautomatic->clientId = $row['client_id'];
		$premiumautomatic->userid = $row['userid'];


		return $premiumautomatic;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PremiumautomaticMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>