<?php

/**
 * Class that operate on table 'programsettings'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-08-13 02:39
 */
class ProgramsettingsMySqlDAO implements ProgramsettingsDAO
{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProgramsettingsMySql
     */
    public function load($id)
    {
        $sql = 'SELECT * FROM programsettings WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll()
    {
        $sql = 'SELECT * FROM programsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn)
    {
        $sql = 'SELECT * FROM programsettings ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param programsetting primary key
     */
    public function delete($programsettingsid)
    {
        $sql = 'DELETE FROM programsettings WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($programsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProgramsettingsMySql programsetting
     */
    public function insert($programsetting)
    {
        $sql = 'INSERT INTO programsettings (companyname, address, specializtion, phone, faxnumber, email, website, logo, roundnumbers, saveprinting, deptprinting, printingpapersize, userid, showPreviousPrice,parcode,priceing,lastprice,searchvalue,clientsearchvalue,updateproductprice,`partition`,taxcard, commercialregistration,costcenter,clinic,workshop,transport,manufacturing,masterCopy , dailyentrydate , updatefiledate,workerbetweenstores,workshoptimeout,drivertimeout,currancy,serial,allowdateedit,clientcode,clientserial,timezone ,expiredate , production , description , service , date , limitamount , measuringunit , print_amount , billid ,precentages , realprice , delegate_seller , storeserial,colortype , nakdyOnly , nakdyKashf , discount_pres_direct , general_discount , sells_return,scunitname,vatValue,syncstructure,showPrevPrices,isOpticProg ,reportsPlusHours , showM5zon,restaurantStoreId,restuarantPrintTimeout,sumSameProductForStore,editAllPrice,isCafe,isRestaurent,productDays,thereIsRestTax,restTaxVal,restPrintLang,taxNameFlag,parcodeDigits,specializedParcodeDigits,clientDefaultDebtLimit,clientDefaultDebtLimitControl,usedParcode,productbycodeimage,commentClient,Inventoryevaluation,Profitevaluation,delivery,premiums,operationnumEdit,noOfDecimalPlaces,unReviewBills,unReviewBillsPass,billReviewNote,tamweenBakery,three_months,six_months,twelve_months,eighteen_months,twentyfour_months,thirty_months,sixthirty_months,fortytwo_months,fortyeight_months,mandobCollectionRatio,takeAwayClient,restaurantServiceOn,earlyrepayment,visaPay,headerPrint,headerPrintSand,printSand,makeDailyEntry,clientShowTawla,billRest,suppIsClientToo,isCarBill,expensesproduct,projectshownew,showparcode,changeBuyPriceChangeSellInBuyBillCtrl,changeBuyPriceChangeSellInProductCtrl,inventoryvaluation,showBillCollectionSearch,showCurrency,qrerp,valueadded,qrcodesh,printfoot,sellorder,numberprint,valueaddedbuy,simpleAddClientInBill,licenseNo,maintenance,showPrevDiscount,vatvalueqr,imgprinthide,parcodeprinttype,parcodeprintwidth,parcodeprinttextsize,parcodeprintCurr,sizecolorDigits,searchBarcodeInBill,sendBillToRestaurant,obgyPharmacyGroups,updateProUnitPricesOnPriceUpdate,ebill,valueaddeddiscount,clientdetail,showPrevPricesRet,showPrevDiscountRet,eunitInTax,showStoreToDetail,showBuyPriceAtProductddl,specialexpenses,ratioshow,defaultUnitPriceAtBill,rulers,quantitynew,showBillOperationSearch,obygyFolder,clientsell,preorderperiod,useListPrice,ebillclient,importproduct,realestateunits,expensesupplier, changeOrderproduct,searchlimit,typebill,roundnumbersbilltotal,noOfDecimalPlacesBillTotal,dailyEntryCostprice,storeRecieveType,clientPhoneReq,addServiceToBill,realestatedev,showprice4,showprice5,showprice6,showprice7,showprice8,showpriceall,showpricehalf,showpriceunit,showbillstatus,showbilldeliverydate,enablequantityfractions,addclienttoproduct,closingcustomeraccount,serial2,`shownameE`,`showprocode`,`showpartnumber`,`showtype`,`showcompany`,`showweight`,`showorigin`,`showhscode`,`showexpire`,`showgrantduration`,`showonline`,`showminappear`,`showonlinecat`,`showsellpercentage`,`showbuydiscount`,`preparingStore`,`sellordername`,`showsearchfilter`,unitPriceAtsalesreport,medExCat,laterNakdiClientId,headerPrint12Right,headerPrint12Left,halfPriceStart,allPriceStart,checkretsellclient) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ,?,?,?, ?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?,?,? ,?,? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($programsetting->companyname);
        $sqlQuery->set($programsetting->address);
        $sqlQuery->set($programsetting->specializtion);
        $sqlQuery->set($programsetting->phone);
        $sqlQuery->set($programsetting->faxnumber);
        $sqlQuery->set($programsetting->email);
        $sqlQuery->set($programsetting->website);
        $sqlQuery->set($programsetting->logo);
        $sqlQuery->setNumber($programsetting->roundnumbers);
        $sqlQuery->setNumber($programsetting->saveprinting);
        $sqlQuery->setNumber($programsetting->deptprinting);
        $sqlQuery->setNumber($programsetting->printingpapersize);
        $sqlQuery->setNumber($programsetting->userid);
        $sqlQuery->setNumber($programsetting->showPreviousPrice);
        $sqlQuery->setNumber($programsetting->parcode);
        $sqlQuery->setNumber($programsetting->priceing);
        $sqlQuery->setNumber($programsetting->lastprice);
        $sqlQuery->setNumber($programsetting->searchvalue);
        $sqlQuery->setNumber($programsetting->clientsearchvalue);
        $sqlQuery->setNumber($programsetting->updateproductprice);
        $sqlQuery->set($programsetting->partition);
        $sqlQuery->set($programsetting->taxcard);
        $sqlQuery->set($programsetting->commercialregistration);
        $sqlQuery->setNumber($programsetting->costcenter);
        $sqlQuery->setNumber($programsetting->clinic);
        $sqlQuery->setNumber($programsetting->workshop);
        $sqlQuery->setNumber($programsetting->transport);
        $sqlQuery->setNumber($programsetting->manufacturing);
        $sqlQuery->setNumber($programsetting->masterCopy);



        $sqlQuery->set($programsetting->dailyentrydate);
        $sqlQuery->set($programsetting->updatefiledate);

        $sqlQuery->setNumber($programsetting->workerbetweenstores);
        $sqlQuery->setNumber($programsetting->workshoptimeout);
        $sqlQuery->setNumber($programsetting->drivertimeout);
        $sqlQuery->set($programsetting->currancy);

        $sqlQuery->set($programsetting->serial);
        $sqlQuery->setNumber($programsetting->allowdateedit);

        $sqlQuery->set($programsetting->clientcode);
        $sqlQuery->set($programsetting->clientserial);
        $sqlQuery->set($programsetting->timezone);
        $sqlQuery->setNumber($programsetting->expiredate);
        $sqlQuery->setNumber($programsetting->production);
        $sqlQuery->setNumber($programsetting->description);
        $sqlQuery->setNumber($programsetting->service);
        $sqlQuery->setNumber($programsetting->date);
        $sqlQuery->setNumber($programsetting->limitamount);
        $sqlQuery->setNumber($programsetting->measuringunit);
        $sqlQuery->setNumber($programsetting->print_amount);
        $sqlQuery->setNumber($programsetting->billid);
        $sqlQuery->setNumber($programsetting->precentages);
        $sqlQuery->setNumber($programsetting->realprice);
        $sqlQuery->setNumber($programsetting->delegate_seller);
        $sqlQuery->setNumber((int) $programsetting->storeserial);
        $sqlQuery->setNumber($programsetting->colortype);
        $sqlQuery->setNumber($programsetting->nakdyOnly);
        $sqlQuery->setNumber($programsetting->nakdyKashf);
        $sqlQuery->setNumber($programsetting->discount_pres_direct);
        $sqlQuery->setNumber($programsetting->general_discount);
        $sqlQuery->setNumber($programsetting->sells_return);
        $sqlQuery->set($programsetting->scunitname);
        $sqlQuery->setNumber($programsetting->vatValue);
        $sqlQuery->setNumber($programsetting->syncstructure);
        $sqlQuery->setNumber($programsetting->showPrevPrices);
        $sqlQuery->setNumber($programsetting->isOpticProg);
        $sqlQuery->setNumber($programsetting->reportsPlusHours);
        $sqlQuery->setNumber((int) $programsetting->showM5zon);
        $sqlQuery->setNumber($programsetting->restaurantStoreId);
        $sqlQuery->setNumber($programsetting->restuarantPrintTimeout);
        $sqlQuery->setNumber((int) $programsetting->sumSameProductForStore);
        $sqlQuery->setNumber((int) $programsetting->editAllPrice);
        $sqlQuery->setNumber((int) $programsetting->isCafe);
        $sqlQuery->setNumber((int) $programsetting->isRestaurent);
        $sqlQuery->setNumber((int) $programsetting->productDays);
        $sqlQuery->setNumber((int) $programsetting->thereIsRestTax);

        $sqlQuery->setNumber((float) $programsetting->restTaxVal);
        $sqlQuery->setNumber((int) $programsetting->restPrintLang);
        $sqlQuery->setNumber((int) $programsetting->taxNameFlag);
        $sqlQuery->setNumber((int) $programsetting->parcodeDigits);
        $sqlQuery->setNumber((int) $programsetting->specializedParcodeDigits);
        $sqlQuery->setNumber((float) $programsetting->clientDefaultDebtLimit);
        $sqlQuery->setNumber((int) $programsetting->clientDefaultDebtLimitControl);
        $sqlQuery->setNumber((int) $programsetting->usedParcode);
        $sqlQuery->set($programsetting->productbycodeimage);
        $sqlQuery->set($programsetting->commentClient);
        $sqlQuery->set($programsetting->Inventoryevaluation); //تقييم المخزون
        $sqlQuery->set($programsetting->Profitevaluation); //تقييم الارباح
        $sqlQuery->set($programsetting->delivery); //شحن وتوصيل
        $sqlQuery->set($programsetting->premiums); //الاقساط
        $sqlQuery->set((int) $programsetting->operationnumEdit);
        $sqlQuery->set((int) $programsetting->noOfDecimalPlaces);
        $sqlQuery->set((int) $programsetting->unReviewBills);
        $sqlQuery->set($programsetting->unReviewBillsPass);
        $sqlQuery->set($programsetting->billReviewNote);
        $sqlQuery->setNumber((int) $programsetting->tamweenBakery);
        $sqlQuery->setNumber((int) $programsetting->three_months);
        $sqlQuery->setNumber((int) $programsetting->six_months);
        $sqlQuery->setNumber((int) $programsetting->twelve_months);
        $sqlQuery->setNumber((int) $programsetting->eighteen_months);
        $sqlQuery->setNumber((int) $programsetting->twentyfour_months);
        $sqlQuery->setNumber((int) $programsetting->thirty_months);
        $sqlQuery->setNumber((int) $programsetting->sixthirty_months);
        $sqlQuery->setNumber((int) $programsetting->fortytwo_months);
        $sqlQuery->setNumber((int) $programsetting->fortyeight_months);
        $sqlQuery->setNumber((int) $programsetting->mandobCollectionRatio);
        $sqlQuery->setNumber((int) $programsetting->takeAwayClient);
        $sqlQuery->set($programsetting->restaurantServiceOn);
        $sqlQuery->setNumber((int) $programsetting->earlyrepayment);
        $sqlQuery->setNumber((int) $programsetting->visaPay);
        $sqlQuery->set($programsetting->headerPrint);
        $sqlQuery->set($programsetting->headerPrintSand);
        $sqlQuery->setNumber($programsetting->printSand);
        $sqlQuery->setNumber((int) $programsetting->makeDailyEntry);
        $sqlQuery->setNumber((int) $programsetting->clientShowTawla);
        $sqlQuery->setNumber((int) $programsetting->billRest);
        $sqlQuery->setNumber((int) $programsetting->suppIsClientToo);
        $sqlQuery->setNumber((int) $programsetting->isCarBill);
        $sqlQuery->setNumber((int) $programsetting->expensesproduct);
        $sqlQuery->setNumber((int) $programsetting->projectshownew);
        $sqlQuery->setNumber((int) $programsetting->showparcode);
        $sqlQuery->setNumber((int) $programsetting->changeBuyPriceChangeSellInBuyBillCtrl);
        $sqlQuery->setNumber((int) $programsetting->changeBuyPriceChangeSellInProductCtrl);
        $sqlQuery->setNumber((int) $programsetting->inventoryvaluation);
        $sqlQuery->setNumber((int) $programsetting->showBillCollectionSearch);
        $sqlQuery->setNumber((int) $programsetting->showCurrency);
        $sqlQuery->setNumber((int) $programsetting->qrerp);
        $sqlQuery->setNumber((int) $programsetting->valueadded);
        $sqlQuery->setNumber((int) $programsetting->qrcodesh);
        $sqlQuery->set($programsetting->printfoot);
        $sqlQuery->setNumber((int) $programsetting->sellorder);
        $sqlQuery->setNumber((int) $programsetting->numberprint);
        $sqlQuery->setNumber((int) $programsetting->valueaddedbuy);
        $sqlQuery->setNumber((int) $programsetting->simpleAddClientInBill);
        $sqlQuery->set($programsetting->licenseNo);
        $sqlQuery->setNumber((int) $programsetting->maintenance);
        $sqlQuery->setNumber((int) $programsetting->showPrevDiscount);
        $sqlQuery->setNumber((float) $programsetting->vatvalueqr);
        $sqlQuery->setNumber((int) $programsetting->imgprinthide);
        $sqlQuery->set($programsetting->parcodeprinttype);
        $sqlQuery->setNumber((int) $programsetting->parcodeprintwidth);
        $sqlQuery->setNumber((int) $programsetting->parcodeprinttextsize);
        $sqlQuery->set($programsetting->parcodeprintCurr);
        $sqlQuery->setNumber((int) $programsetting->sizecolorDigits);
        $sqlQuery->setNumber((int) $programsetting->searchBarcodeInBill);
        $sqlQuery->setNumber((int) $programsetting->sendBillToRestaurant);
        $sqlQuery->set($programsetting->obgyPharmacyGroups);
        $sqlQuery->setNumber((int) $programsetting->updateProUnitPricesOnPriceUpdate);
        $sqlQuery->setNumber((int) $programsetting->ebill);
        $sqlQuery->setNumber((int) $programsetting->valueaddeddiscount);
        $sqlQuery->setNumber((int) $programsetting->clientdetail);
        $sqlQuery->setNumber((int) $programsetting->showPrevPricesRet);
        $sqlQuery->setNumber((int) $programsetting->showPrevDiscountRet);
        $sqlQuery->set($programsetting->eunitInTax);
        $sqlQuery->setNumber((int) $programsetting->showStoreToDetail);
        $sqlQuery->setNumber((int) $programsetting->showBuyPriceAtProductddl);
        $sqlQuery->setNumber((int) $programsetting->specialexpenses);
        $sqlQuery->setNumber((int) $programsetting->ratioshow);
        $sqlQuery->setNumber((int) $programsetting->defaultUnitPriceAtBill);
        $sqlQuery->setNumber((int) $programsetting->rulers);
        $sqlQuery->setNumber((int) $programsetting->quantitynew);
        $sqlQuery->setNumber((int) $programsetting->showBillOperationSearch);
        $sqlQuery->set($programsetting->obygyFolder);
        $sqlQuery->setNumber((int) $programsetting->clientsell);
        $sqlQuery->setNumber((int) $programsetting->preorderperiod);
        $sqlQuery->setNumber((int) $programsetting->useListPrice);
        $sqlQuery->setNumber((int) $programsetting->ebillclient);
        $sqlQuery->setNumber((int) $programsetting->importproduct);
        $sqlQuery->setNumber((int) $programsetting->realestateunits);
        $sqlQuery->setNumber((int) $programsetting->expensesupplier);
        $sqlQuery->setNumber($programsetting->changeOrderproduct);
        $sqlQuery->setNumber($programsetting->searchlimit);
        $sqlQuery->set($programsetting->typebill);
        $sqlQuery->setNumber((int) $programsetting->roundnumbersbilltotal);
        $sqlQuery->setNumber((int) $programsetting->noOfDecimalPlacesBillTotal);
        $sqlQuery->set($programsetting->dailyEntryCostprice);
        $sqlQuery->setNumber((int) $programsetting->storeRecieveType);
        $sqlQuery->setNumber((int) $programsetting->clientPhoneReq);
        $sqlQuery->setNumber((int) $programsetting->addServiceToBill);
        $sqlQuery->setNumber((int) $programsetting->realestatedev);
        $sqlQuery->setNumber((int) $programsetting->showprice4);
        $sqlQuery->setNumber((int) $programsetting->showprice5);
        $sqlQuery->setNumber((int) $programsetting->showprice6);
        $sqlQuery->setNumber((int) $programsetting->showprice7);
        $sqlQuery->setNumber((int) $programsetting->showprice8);
        $sqlQuery->setNumber((int) $programsetting->showpriceall);
        $sqlQuery->setNumber((int) $programsetting->showpricehalf);
        $sqlQuery->setNumber((int) $programsetting->showpriceunit);
        $sqlQuery->setNumber((int) $programsetting->showbillstatus);
        $sqlQuery->setNumber((int) $programsetting->showbilldeliverydate);
        $sqlQuery->setNumber((int) $programsetting->enablequantityfractions);
        $sqlQuery->setNumber((int) $programsetting->addclienttoproduct);
        $sqlQuery->setNumber((int) $programsetting->closingcustomeraccount);
        $sqlQuery->set($programsetting->serial2);
        $sqlQuery->setNumber((int) $programsetting->shownameE);
        $sqlQuery->setNumber((int) $programsetting->showprocode);
        $sqlQuery->setNumber((int) $programsetting->showpartnumber);
        $sqlQuery->setNumber((int) $programsetting->showtype);
        $sqlQuery->setNumber((int) $programsetting->showcompany);
        $sqlQuery->setNumber((int) $programsetting->showweight);
        $sqlQuery->setNumber((int) $programsetting->showorigin);
        $sqlQuery->setNumber((int) $programsetting->showhscode);
        $sqlQuery->setNumber((int) $programsetting->showexpire);
        $sqlQuery->setNumber((int) $programsetting->showgrantduration);
        $sqlQuery->setNumber((int) $programsetting->showonline);
        $sqlQuery->setNumber((int) $programsetting->showminappear);
        $sqlQuery->setNumber((int) $programsetting->showonlinecat);
        $sqlQuery->setNumber((int) $programsetting->showsellpercentage);
        $sqlQuery->setNumber((int) $programsetting->showbuydiscount);
        $sqlQuery->setNumber((int) $programsetting->preparingStore);
        $sqlQuery->setNumber($programsetting->sellordername);
        $sqlQuery->setNumber((int) $programsetting->showsearchfilter);
        $sqlQuery->setNumber((int) $programsetting->unitPriceAtsalesreport);
        $sqlQuery->setNumber((int) $programsetting->medExCat);
        $sqlQuery->setNumber((int) $programsetting->laterNakdiClientId);
        $sqlQuery->set($programsetting->headerPrint12Right);
        $sqlQuery->set($programsetting->headerPrint12Left);
        $sqlQuery->setNumber((int) $programsetting->halfPriceStart);
        $sqlQuery->setNumber((int) $programsetting->allPriceStart);
        $sqlQuery->setNumber((int) $programsetting->checkretsellclient);

        $id = $this->executeInsert($sqlQuery);
        $programsetting->programsettingsid = $id;

        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProgramsettingsMySql programsetting
     */
    public function update($programsetting)
    {
        $sql = 'UPDATE programsettings SET companyname = ?, address = ?, specializtion = ?, phone = ?, faxnumber = ?,'
            . ' email = ?, website = ?, logo = ?, roundnumbers = ?, saveprinting = ?,'
            . ' deptprinting = ?, printingpapersize = ?, userid = ?, showPreviousPrice = ?, '
            . 'parcode = ?, priceing = ?, lastprice = ?, searchvalue = ?,clientsearchvalue = ?, updateproductprice = ?, '
            . 'allowfinsldelete = ?, updateclientprice = ?, `partition` = ?, taxcard = ?, '
            . 'commercialregistration = ?, costcenter = ?, clinic = ?, workshop = ?, transport = ?,'
            . ' manufacturing = ?, masterCopy = ? , dailyentrydate = ? ,updatefiledate = ?,workerbetweenstores = ?,'
            . 'workshoptimeout = ?,drivertimeout = ?,currancy = ?,serial=?,allowdateedit = ?, clientcode = ? '
            . ',clientserial = ?,timezone = ? , expiredate =? , production =? , description=? , service =?'
            . ' , date=? , limitamount = ? , measuringunit = ? , print_amount = ? , billid = ? , precentages = ? '
            . ', realprice = ? ,delegate_seller = ? , storeserial = ? ,clientfieldrequired =? , clientcodname=? , colortype = ? ,'
            . ' nakdyOnly = ? , nakdyKashf = ? , discount_pres_direct = ? , general_discount = ? ,'
            . ' sells_return = ? ,scunitname =?,vatValue = ?,syncstructure = ?,showPrevPrices = ?,isOpticProg=?,reportsPlusHours = ? , showM5zon = ?,restaurantStoreId = ?,restuarantPrintTimeout = ?,sumSameProductForStore = ?, editAllPrice = ?,'
            . ' isCafe = ? ,isRestaurent = ? ,productDays = ?,thereIsRestTax = ?,restTaxVal = ?,restPrintLang = ?,taxNameFlag = ?,parcodeDigits = ? ,specializedParcodeDigits = ?,'
            . ' clientDefaultDebtLimit = ? , clientDefaultDebtLimitControl = ?,usedParcode = ? ,productbycodeimage = ? ,commentClient=?,Inventoryevaluation=?,Profitevaluation=? , delivery=?,premiums = ?,operationnumEdit = ?,noOfDecimalPlaces = ?,'
            . 'unReviewBills = ?, unReviewBillsPass = ?,billReviewNote = ?,tamweenBakery = ?,three_months = ?,six_months = ?,twelve_months = ?,eighteen_months = ?,twentyfour_months = ?,thirty_months = ?,sixthirty_months = ?,fortytwo_months = ?,fortyeight_months = ?,'
            . 'mandobCollectionRatio=?,takeAwayClient = ?,restaurantServiceOn = ?,earlyrepayment = ?,visaPay = ?,headerPrint=?,headerPrintSand=?,printSand=?,makeDailyEntry=?,clientShowTawla=?,billRest=?,suppIsClientToo=?,isCarBill=?,expensesproduct=?,projectshownew=?,showparcode=?'
            . ',changeBuyPriceChangeSellInBuyBillCtrl = ?,changeBuyPriceChangeSellInProductCtrl = ?,inventoryvaluation = ?,showBillCollectionSearch=?,incomeclient=?,showserial=?,editservice=?,showCurrency=?,qrerp=?,valueadded=?,qrcodesh=?,printfoot=?,sellorder=?,numberprint=?,valueaddedbuy=?,simpleAddClientInBill=?,licenseNo=?,maintenance=?,showPrevDiscount=?,vatvalueqr=?,imgprinthide=?'
            . ',parcodeprinttype = ?,parcodeprintwidth=?,parcodeprinttextsize=?,parcodeprintCurr=?,sizecolorDigits=?,searchBarcodeInBill=?,allowMobileLogin=?,lanAllowType=?,wanAllowType=?,sendBillToRestaurant=?,obgyPharmacyGroups=?,updateProUnitPricesOnPriceUpdate=?,ebill=?,valueaddeddiscount=?,clientdetail=?,showPrevPricesRet=?,showPrevDiscountRet=?,eunitInTax=?,showStoreToDetail=?,showBuyPriceAtProductddl=?,specialexpenses=?,ratioshow=?,defaultUnitPriceAtBill=?,rulers=?,quantitynew=?,showBillOperationSearch=?,obygyFolder=?,clientsell=?,
                preorderperiod=?,useListPrice=?,ebillclient=?,importproduct=?,realestateunits=?,expensesupplier=?,changeOrderproduct=?,searchlimit=?,typebill=?,roundnumbersbilltotal=?,noOfDecimalPlacesBillTotal=?,dailyEntryCostprice=?,storeRecieveType=?,clientPhoneReq=?,addServiceToBill=?,realestatedev=?,showprice4=?,showprice5=?,showprice6=?,showprice7=?,showprice8=?,showpriceall=?,showpricehalf=?,showpriceunit=?,showbillstatus=?,showbilldeliverydate=?,enablequantityfractions=?,addclienttoproduct=?,closingcustomeraccount=?,serial2=?,
                shownameE=?,showprocode=?,showpartnumber=?,showtype=?,showcompany=?,showweight=?,showorigin=?,showhscode=?,showexpire=?,showgrantduration=?,showonline=?,showminappear=?,showonlinecat=?,showsellpercentage=?,showbuydiscount=?,preparingStore=?,sellordername=?,showsearchfilter=?,unitPriceAtsalesreport=?,medExCat=?,laterNakdiClientId=?,headerPrint12Right=?,headerPrint12Left=?,halfPriceStart=?,allPriceStart=?,checkretsellclient=?'
            . ' WHERE programsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($programsetting->companyname);
        $sqlQuery->set($programsetting->address);
        $sqlQuery->set($programsetting->specializtion);
        $sqlQuery->set($programsetting->phone);
        $sqlQuery->set($programsetting->faxnumber);
        $sqlQuery->set($programsetting->email);
        $sqlQuery->set($programsetting->website);
        $sqlQuery->set($programsetting->logo);
        $sqlQuery->setNumber($programsetting->roundnumbers);
        $sqlQuery->setNumber($programsetting->saveprinting);
        $sqlQuery->setNumber($programsetting->deptprinting);
        $sqlQuery->setNumber($programsetting->printingpapersize);
        $sqlQuery->setNumber($programsetting->userid);
        $sqlQuery->setNumber($programsetting->showPreviousPrice);
        $sqlQuery->setNumber($programsetting->parcode);
        $sqlQuery->setNumber($programsetting->priceing);
        $sqlQuery->setNumber($programsetting->lastprice);
        $sqlQuery->setNumber($programsetting->searchvalue);
        $sqlQuery->setNumber($programsetting->clientsearchvalue);
        $sqlQuery->setNumber($programsetting->updateproductprice);
        $sqlQuery->setNumber($programsetting->allowfinsldelete);
        $sqlQuery->setNumber($programsetting->updateclientprice);
        $sqlQuery->set($programsetting->partition);
        $sqlQuery->set($programsetting->taxcard);
        $sqlQuery->set($programsetting->commercialregistration);
        $sqlQuery->setNumber($programsetting->costcenter);

        $sqlQuery->setNumber($programsetting->clinic);
        $sqlQuery->setNumber($programsetting->workshop);
        $sqlQuery->setNumber($programsetting->transport);
        $sqlQuery->setNumber($programsetting->manufacturing);
        $sqlQuery->setNumber($programsetting->masterCopy);


        $sqlQuery->set($programsetting->dailyentrydate);
        $sqlQuery->set($programsetting->updatefiledate);

        $sqlQuery->setNumber($programsetting->workerbetweenstores);
        $sqlQuery->setNumber($programsetting->workshoptimeout);
        $sqlQuery->setNumber($programsetting->drivertimeout);

        $sqlQuery->set($programsetting->currancy);
        $sqlQuery->set($programsetting->serial);

        $sqlQuery->setNumber($programsetting->allowdateedit);

        $sqlQuery->set($programsetting->clientcode);
        $sqlQuery->set($programsetting->clientserial);
        $sqlQuery->set($programsetting->timezone);
        $sqlQuery->setNumber($programsetting->expiredate);
        $sqlQuery->setNumber($programsetting->production);
        $sqlQuery->setNumber($programsetting->description);
        $sqlQuery->setNumber($programsetting->service);
        $sqlQuery->setNumber($programsetting->date);
        $sqlQuery->setNumber($programsetting->limitamount);
        $sqlQuery->setNumber($programsetting->measuringunit);
        $sqlQuery->setNumber($programsetting->print_amount);
        $sqlQuery->setNumber($programsetting->billid);
        $sqlQuery->setNumber($programsetting->precentages);
        $sqlQuery->setNumber($programsetting->realprice);
        $sqlQuery->setNumber($programsetting->delegate_seller);
        $sqlQuery->setNumber((int) $programsetting->storeserial);
        $sqlQuery->setNumber($programsetting->clientfieldrequired);
        $sqlQuery->set($programsetting->clientcodname);
        $sqlQuery->set($programsetting->colortype);
        $sqlQuery->setNumber($programsetting->nakdyOnly);
        $sqlQuery->setNumber($programsetting->nakdyKashf);
        $sqlQuery->setNumber($programsetting->discount_pres_direct);
        $sqlQuery->setNumber($programsetting->general_discount);
        $sqlQuery->setNumber($programsetting->sells_return);
        $sqlQuery->set($programsetting->scunitname);
        $sqlQuery->setNumber($programsetting->vatValue);
        $sqlQuery->setNumber($programsetting->syncstructure);
        $sqlQuery->setNumber($programsetting->showPrevPrices);
        $sqlQuery->setNumber($programsetting->isOpticProg);
        $sqlQuery->setNumber($programsetting->reportsPlusHours);
        $sqlQuery->setNumber((int) $programsetting->showM5zon);
        $sqlQuery->setNumber($programsetting->restaurantStoreId);
        $sqlQuery->setNumber($programsetting->restuarantPrintTimeout);
        $sqlQuery->setNumber((int) $programsetting->sumSameProductForStore);
        $sqlQuery->setNumber((int) $programsetting->editAllPrice);
        $sqlQuery->setNumber((int) $programsetting->isCafe);
        $sqlQuery->setNumber((int) $programsetting->isRestaurent);
        $sqlQuery->setNumber((int) $programsetting->productDays);
        $sqlQuery->setNumber((int) $programsetting->thereIsRestTax);
        $sqlQuery->setNumber((float) $programsetting->restTaxVal);
        $sqlQuery->setNumber((int) $programsetting->restPrintLang);
        $sqlQuery->setNumber((int) $programsetting->taxNameFlag);
        $sqlQuery->setNumber((int) $programsetting->parcodeDigits);
        $sqlQuery->setNumber((int) $programsetting->specializedParcodeDigits);
        $sqlQuery->setNumber((float) $programsetting->clientDefaultDebtLimit);
        $sqlQuery->setNumber((int) $programsetting->clientDefaultDebtLimitControl);
        $sqlQuery->setNumber((int) $programsetting->usedParcode);
        $sqlQuery->set($programsetting->productbycodeimage);
        $sqlQuery->set($programsetting->commentClient);
        $sqlQuery->set($programsetting->Inventoryevaluation); //تقييم المخزون
        $sqlQuery->set($programsetting->Profitevaluation); //تقييم الارباح
        $sqlQuery->set($programsetting->delivery); //شحن وتوصيل
        $sqlQuery->set($programsetting->premiums); //الاقساط
        $sqlQuery->set((int) $programsetting->operationnumEdit);
        $sqlQuery->set((int) $programsetting->noOfDecimalPlaces);
        $sqlQuery->set((int) $programsetting->unReviewBills);
        $sqlQuery->set($programsetting->unReviewBillsPass);
        $sqlQuery->set($programsetting->billReviewNote);
        $sqlQuery->setNumber($programsetting->tamweenBakery);
        $sqlQuery->setNumber((int) $programsetting->three_months);
        $sqlQuery->setNumber((int) $programsetting->six_months);
        $sqlQuery->setNumber((int) $programsetting->twelve_months);
        $sqlQuery->setNumber((int) $programsetting->eighteen_months);
        $sqlQuery->setNumber((int) $programsetting->twentyfour_months);
        $sqlQuery->setNumber((int) $programsetting->thirty_months);
        $sqlQuery->setNumber((int) $programsetting->sixthirty_months);
        $sqlQuery->setNumber((int) $programsetting->fortytwo_months);
        $sqlQuery->setNumber((int) $programsetting->fortyeight_months);
        $sqlQuery->setNumber((int) $programsetting->mandobCollectionRatio);
        $sqlQuery->setNumber((int) $programsetting->takeAwayClient);
        $sqlQuery->set($programsetting->restaurantServiceOn);
        $sqlQuery->setNumber((int) $programsetting->earlyrepayment);
        $sqlQuery->setNumber((int) $programsetting->visaPay);
        $sqlQuery->set($programsetting->headerPrint);
        $sqlQuery->set($programsetting->headerPrintSand);
        $sqlQuery->setNumber($programsetting->printSand);
        $sqlQuery->setNumber((int) $programsetting->makeDailyEntry);
        $sqlQuery->setNumber((int) $programsetting->clientShowTawla);
        $sqlQuery->setNumber((int) $programsetting->billRest);
        $sqlQuery->setNumber((int) $programsetting->suppIsClientToo);
        $sqlQuery->setNumber((int) $programsetting->isCarBill);
        $sqlQuery->setNumber((int) $programsetting->expensesproduct);
        $sqlQuery->setNumber((int) $programsetting->projectshownew);
        $sqlQuery->setNumber((int) $programsetting->showparcode);
        $sqlQuery->setNumber((int) $programsetting->changeBuyPriceChangeSellInBuyBillCtrl);
        $sqlQuery->setNumber((int) $programsetting->changeBuyPriceChangeSellInProductCtrl);
        $sqlQuery->setNumber((int) $programsetting->inventoryvaluation);
        $sqlQuery->setNumber((int) $programsetting->showBillCollectionSearch);
        $sqlQuery->setNumber((int) $programsetting->incomeclient);
        $sqlQuery->setNumber((int) $programsetting->showserial);
        $sqlQuery->setNumber((int) $programsetting->editservice);
        $sqlQuery->setNumber((int) $programsetting->showCurrency);
        $sqlQuery->setNumber((int) $programsetting->qrerp);
        $sqlQuery->setNumber((int) $programsetting->valueadded);
        $sqlQuery->setNumber((int) $programsetting->qrcodesh);
        $sqlQuery->set($programsetting->printfoot);
        $sqlQuery->setNumber((int) $programsetting->sellorder);
        $sqlQuery->setNumber((int) $programsetting->numberprint);
        $sqlQuery->setNumber((int) $programsetting->valueaddedbuy);
        $sqlQuery->setNumber((int) $programsetting->simpleAddClientInBill);
        $sqlQuery->set($programsetting->licenseNo);
        $sqlQuery->setNumber((int) $programsetting->maintenance);
        $sqlQuery->setNumber((int) $programsetting->showPrevDiscount);
        $sqlQuery->setNumber((float) $programsetting->vatvalueqr);
        $sqlQuery->setNumber((int) $programsetting->imgprinthide);
        $sqlQuery->set($programsetting->parcodeprinttype);
        $sqlQuery->setNumber((int) $programsetting->parcodeprintwidth);
        $sqlQuery->setNumber((int) $programsetting->parcodeprinttextsize);
        $sqlQuery->set($programsetting->parcodeprintCurr);
        $sqlQuery->setNumber((int) $programsetting->sizecolorDigits);
        $sqlQuery->setNumber((int) $programsetting->searchBarcodeInBill);
        $sqlQuery->setNumber((int) $programsetting->allowMobileLogin);
        $sqlQuery->setNumber((int) $programsetting->lanAllowType);
        $sqlQuery->setNumber((int) $programsetting->wanAllowType);
        $sqlQuery->setNumber((int) $programsetting->sendBillToRestaurant);
        $sqlQuery->set($programsetting->obgyPharmacyGroups);
        $sqlQuery->setNumber((int) $programsetting->updateProUnitPricesOnPriceUpdate);
        $sqlQuery->setNumber((int) $programsetting->ebill);
        $sqlQuery->setNumber((int) $programsetting->valueaddeddiscount);
        $sqlQuery->setNumber((int) $programsetting->clientdetail);
        $sqlQuery->setNumber((int) $programsetting->showPrevPricesRet);
        $sqlQuery->setNumber((int) $programsetting->showPrevDiscountRet);
        $sqlQuery->set($programsetting->eunitInTax);
        $sqlQuery->setNumber((int) $programsetting->showStoreToDetail);
        $sqlQuery->setNumber((int) $programsetting->showBuyPriceAtProductddl);
        $sqlQuery->setNumber((int) $programsetting->specialexpenses);
        $sqlQuery->setNumber((int) $programsetting->ratioshow);
        $sqlQuery->setNumber((int) $programsetting->defaultUnitPriceAtBill);
        $sqlQuery->setNumber((int) $programsetting->rulers);
        $sqlQuery->setNumber((int) $programsetting->quantitynew);
        $sqlQuery->setNumber((int) $programsetting->showBillOperationSearch);
        $sqlQuery->set($programsetting->obygyFolder);
        $sqlQuery->setNumber((int) $programsetting->clientsell);
        $sqlQuery->setNumber((int) $programsetting->preorderperiod);
        $sqlQuery->setNumber((int) $programsetting->useListPrice);
        $sqlQuery->setNumber((int) $programsetting->ebillclient);
        $sqlQuery->setNumber((int) $programsetting->importproduct);
        $sqlQuery->setNumber((int) $programsetting->realestateunits);
        $sqlQuery->setNumber((int) $programsetting->expensesupplier);
        $sqlQuery->setNumber($programsetting->changeOrderproduct);
        $sqlQuery->setNumber($programsetting->searchlimit);
        $sqlQuery->set($programsetting->typebill);
        $sqlQuery->setNumber((int) $programsetting->roundnumbersbilltotal);
        $sqlQuery->setNumber((int) $programsetting->noOfDecimalPlacesBillTotal);
        $sqlQuery->set($programsetting->dailyEntryCostprice);
        $sqlQuery->setNumber((int) $programsetting->storeRecieveType);
        $sqlQuery->setNumber((int) $programsetting->clientPhoneReq);
        $sqlQuery->setNumber((int) $programsetting->addServiceToBill);
        $sqlQuery->setNumber((int) $programsetting->realestatedev);
        $sqlQuery->setNumber((int) $programsetting->showprice4);
        $sqlQuery->setNumber((int) $programsetting->showprice5);
        $sqlQuery->setNumber((int) $programsetting->showprice6);
        $sqlQuery->setNumber((int) $programsetting->showprice7);
        $sqlQuery->setNumber((int) $programsetting->showprice8);
        $sqlQuery->setNumber((int) $programsetting->showpriceall);
        $sqlQuery->setNumber((int) $programsetting->showpricehalf);
        $sqlQuery->setNumber((int) $programsetting->showpriceunit);
        $sqlQuery->setNumber((int) $programsetting->showbillstatus);
        $sqlQuery->setNumber((int) $programsetting->showbilldeliverydate);
        $sqlQuery->setNumber((int) $programsetting->enablequantityfractions);
        $sqlQuery->setNumber((int) $programsetting->addclienttoproduct);
        $sqlQuery->setNumber((int) $programsetting->closingcustomeraccount);
        $sqlQuery->set($programsetting->serial2);
        $sqlQuery->setNumber((int) $programsetting->shownameE);
        $sqlQuery->setNumber((int) $programsetting->showprocode);
        $sqlQuery->setNumber((int) $programsetting->showpartnumber);
        $sqlQuery->setNumber((int) $programsetting->showtype);
        $sqlQuery->setNumber((int) $programsetting->showcompany);
        $sqlQuery->setNumber((int) $programsetting->showweight);
        $sqlQuery->setNumber((int) $programsetting->showorigin);
        $sqlQuery->setNumber((int) $programsetting->showhscode);
        $sqlQuery->setNumber((int) $programsetting->showexpire);
        $sqlQuery->setNumber((int) $programsetting->showgrantduration);
        $sqlQuery->setNumber((int) $programsetting->showonline);
        $sqlQuery->setNumber((int) $programsetting->showminappear);
        $sqlQuery->setNumber((int) $programsetting->showonlinecat);
        $sqlQuery->setNumber((int) $programsetting->showsellpercentage);
        $sqlQuery->setNumber((int) $programsetting->showbuydiscount);
        $sqlQuery->setNumber((int) $programsetting->preparingStore);
        $sqlQuery->setNumber($programsetting->sellordername);
        $sqlQuery->setNumber((int) $programsetting->showsearchfilter);
        $sqlQuery->setNumber((int) $programsetting->unitPriceAtsalesreport);
        $sqlQuery->setNumber((int) $programsetting->medExCat);
        $sqlQuery->setNumber((int) $programsetting->laterNakdiClientId);
        $sqlQuery->set($programsetting->headerPrint12Right);
        $sqlQuery->set($programsetting->headerPrint12Left);
        $sqlQuery->setNumber((int) $programsetting->halfPriceStart);
        $sqlQuery->setNumber((int) $programsetting->allPriceStart);
        $sqlQuery->setNumber((int) $programsetting->checkretsellclient);

        $sqlQuery->setNumber($programsetting->programsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean()
    {
        $sql = 'DELETE FROM programsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCompanyname($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE companyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAddress($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE address = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTopaddress($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE topaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySpecializtion($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE specializtion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPhone($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE phone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPhone2($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE phone2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFaxnumber($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE faxnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmail($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE email = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWebsite($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE website = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLogo($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE logo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRoundnumbers($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE roundnumbers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveprinting($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE saveprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeptprinting($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE deptprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrintingpapersize($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE printingpapersize = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShowPreviousPrice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE showPreviousPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPriceing($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE priceing = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastprice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE lastprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySearchvalue($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE searchvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientsearchvalue($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientsearchvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUpdateproductprice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE updateproductprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAllowfinsldelete($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE allowfinsldelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUpdateclientprice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE updateclientprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartition($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE partition = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTaxcard($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE taxcard = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCommercialregistration($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE commercialregistration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenter($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE costcenter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCopytype($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE copytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUrlcopy($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE urlcopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInternalcopy($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE internalcopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClinic($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clinic = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkshop($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE workshop = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransport($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE transport = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByManufacturing($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE manufacturing = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMasterCopy($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE masterCopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentrydate($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE dailyentrydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUpdatefiledate($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE updatefiledate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkerbetweenstores($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE workerbetweenstores = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkshoptimeout($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE workshoptimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDrivertimeout($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE drivertimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrancy($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE currancy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySerial($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE serial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAllowdateedit($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE allowdateedit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientcode($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientserial($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTimezone($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE timezone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpiredate($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE expiredate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProduction($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE production = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescription($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByService($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDate($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLimitamount($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE limitamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeasuringunit($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE measuringunit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrintAmount($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE print_amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillid($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrecentages($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE precentages = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRealprice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE realprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelegateSeller($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE delegate_seller = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreserial($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE storeserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientcodname($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientcodname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientfieldrequired($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientfieldrequired = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColortype($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE colortype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNakdyOnly($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE nakdyOnly = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNakdyKashf($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE nakdyKashf = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountPresDirect($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE discount_pres_direct = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByGeneralDiscount($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE general_discount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellsReturn($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE sells_return = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByScunitname($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE scunitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVatValue($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE vatValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySyncstructure($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE syncstructure = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShowPrevPrices($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE showPrevPrices = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsOpticProg($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE isOpticProg = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReportsPlusHours($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE reportsPlusHours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShowM5zon($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE showM5zon = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRestaurantStoreId($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE restaurantStoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRestuarantPrintTimeout($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE restuarantPrintTimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySumSameProductForStore($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE sumSameProductForStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEditAllPrice($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE editAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsCafe($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE isCafe = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsRestaurent($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE isRestaurent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductDays($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE productDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThereIsRestTax($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE thereIsRestTax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRestTaxVal($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE restTaxVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRestPrintLang($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE restPrintLang = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTaxNameFlag($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE taxNameFlag = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcodeDigits($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE parcodeDigits = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySpecializedParcodeDigits($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE specializedParcodeDigits = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientDefaultDebtLimit($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientDefaultDebtLimit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientDefaultDebtLimitControl($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientDefaultDebtLimitControl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUsedParcode($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE usedParcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductbycodeimage($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE productbycodeimage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCommentClient($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE commentClient = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInventoryevaluation($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE Inventoryevaluation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProfitevaluation($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE Profitevaluation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelivery($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPremiums($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE premiums = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperationnumEdit($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE operationnumEdit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNoOfDecimalPlaces($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE noOfDecimalPlaces = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnReviewBills($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE unReviewBills = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnReviewBillsPass($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE unReviewBillsPass = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillReviewNote($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE billReviewNote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTamweenBakery($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE tamweenBakery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCopyRightsStatment($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE copyRightsStatment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThreeMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE three_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySixMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE six_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTwelveMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE twelve_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEighteenMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE eighteen_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTwentyfourMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE twentyfour_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThirtyMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE thirty_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySixthirtyMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE sixthirty_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFortytwoMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE fortytwo_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFortyeightMonths($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE fortyeight_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemoteBackupLink($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE remoteBackupLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemoteBackupUser($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE remoteBackupUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemoteBackupPass($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE remoteBackupPass = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemoteBackupFolder($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE remoteBackupFolder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMandobCollectionRatio($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE mandobCollectionRatio = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTakeAwayClient($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE takeAwayClient = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRestaurantServiceOn($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE restaurantServiceOn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEarlyrepayment($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE earlyrepayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVisaPay($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE visaPay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHeaderPrint($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE headerPrint = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHeaderPrintSand($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE headerPrintSand = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrintSand($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE printSand = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMakeDailyEntry($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE makeDailyEntry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientShowTawla($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE clientShowTawla = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillRest($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE billRest = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySuppIsClientToo($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE suppIsClientToo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsCarBill($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE isCarBill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensesproduct($value)
    {
        $sql = 'SELECT * FROM programsettings WHERE expensesproduct = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCompanyname($value)
    {
        $sql = 'DELETE FROM programsettings WHERE companyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAddress($value)
    {
        $sql = 'DELETE FROM programsettings WHERE address = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTopaddress($value)
    {
        $sql = 'DELETE FROM programsettings WHERE topaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySpecializtion($value)
    {
        $sql = 'DELETE FROM programsettings WHERE specializtion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPhone($value)
    {
        $sql = 'DELETE FROM programsettings WHERE phone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPhone2($value)
    {
        $sql = 'DELETE FROM programsettings WHERE phone2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFaxnumber($value)
    {
        $sql = 'DELETE FROM programsettings WHERE faxnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmail($value)
    {
        $sql = 'DELETE FROM programsettings WHERE email = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWebsite($value)
    {
        $sql = 'DELETE FROM programsettings WHERE website = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLogo($value)
    {
        $sql = 'DELETE FROM programsettings WHERE logo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRoundnumbers($value)
    {
        $sql = 'DELETE FROM programsettings WHERE roundnumbers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveprinting($value)
    {
        $sql = 'DELETE FROM programsettings WHERE saveprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeptprinting($value)
    {
        $sql = 'DELETE FROM programsettings WHERE deptprinting = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrintingpapersize($value)
    {
        $sql = 'DELETE FROM programsettings WHERE printingpapersize = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value)
    {
        $sql = 'DELETE FROM programsettings WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShowPreviousPrice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE showPreviousPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value)
    {
        $sql = 'DELETE FROM programsettings WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPriceing($value)
    {
        $sql = 'DELETE FROM programsettings WHERE priceing = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastprice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE lastprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySearchvalue($value)
    {
        $sql = 'DELETE FROM programsettings WHERE searchvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientsearchvalue($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientsearchvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUpdateproductprice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE updateproductprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAllowfinsldelete($value)
    {
        $sql = 'DELETE FROM programsettings WHERE allowfinsldelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUpdateclientprice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE updateclientprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartition($value)
    {
        $sql = 'DELETE FROM programsettings WHERE partition = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTaxcard($value)
    {
        $sql = 'DELETE FROM programsettings WHERE taxcard = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCommercialregistration($value)
    {
        $sql = 'DELETE FROM programsettings WHERE commercialregistration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenter($value)
    {
        $sql = 'DELETE FROM programsettings WHERE costcenter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCopytype($value)
    {
        $sql = 'DELETE FROM programsettings WHERE copytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUrlcopy($value)
    {
        $sql = 'DELETE FROM programsettings WHERE urlcopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInternalcopy($value)
    {
        $sql = 'DELETE FROM programsettings WHERE internalcopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClinic($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clinic = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkshop($value)
    {
        $sql = 'DELETE FROM programsettings WHERE workshop = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransport($value)
    {
        $sql = 'DELETE FROM programsettings WHERE transport = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByManufacturing($value)
    {
        $sql = 'DELETE FROM programsettings WHERE manufacturing = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMasterCopy($value)
    {
        $sql = 'DELETE FROM programsettings WHERE masterCopy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentrydate($value)
    {
        $sql = 'DELETE FROM programsettings WHERE dailyentrydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUpdatefiledate($value)
    {
        $sql = 'DELETE FROM programsettings WHERE updatefiledate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkerbetweenstores($value)
    {
        $sql = 'DELETE FROM programsettings WHERE workerbetweenstores = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkshoptimeout($value)
    {
        $sql = 'DELETE FROM programsettings WHERE workshoptimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDrivertimeout($value)
    {
        $sql = 'DELETE FROM programsettings WHERE drivertimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrancy($value)
    {
        $sql = 'DELETE FROM programsettings WHERE currancy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySerial($value)
    {
        $sql = 'DELETE FROM programsettings WHERE serial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAllowdateedit($value)
    {
        $sql = 'DELETE FROM programsettings WHERE allowdateedit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientcode($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientserial($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTimezone($value)
    {
        $sql = 'DELETE FROM programsettings WHERE timezone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpiredate($value)
    {
        $sql = 'DELETE FROM programsettings WHERE expiredate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProduction($value)
    {
        $sql = 'DELETE FROM programsettings WHERE production = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescription($value)
    {
        $sql = 'DELETE FROM programsettings WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByService($value)
    {
        $sql = 'DELETE FROM programsettings WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDate($value)
    {
        $sql = 'DELETE FROM programsettings WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLimitamount($value)
    {
        $sql = 'DELETE FROM programsettings WHERE limitamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeasuringunit($value)
    {
        $sql = 'DELETE FROM programsettings WHERE measuringunit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrintAmount($value)
    {
        $sql = 'DELETE FROM programsettings WHERE print_amount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillid($value)
    {
        $sql = 'DELETE FROM programsettings WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrecentages($value)
    {
        $sql = 'DELETE FROM programsettings WHERE precentages = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRealprice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE realprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelegateSeller($value)
    {
        $sql = 'DELETE FROM programsettings WHERE delegate_seller = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreserial($value)
    {
        $sql = 'DELETE FROM programsettings WHERE storeserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientcodname($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientcodname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientfieldrequired($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientfieldrequired = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColortype($value)
    {
        $sql = 'DELETE FROM programsettings WHERE colortype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNakdyOnly($value)
    {
        $sql = 'DELETE FROM programsettings WHERE nakdyOnly = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNakdyKashf($value)
    {
        $sql = 'DELETE FROM programsettings WHERE nakdyKashf = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountPresDirect($value)
    {
        $sql = 'DELETE FROM programsettings WHERE discount_pres_direct = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByGeneralDiscount($value)
    {
        $sql = 'DELETE FROM programsettings WHERE general_discount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellsReturn($value)
    {
        $sql = 'DELETE FROM programsettings WHERE sells_return = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByScunitname($value)
    {
        $sql = 'DELETE FROM programsettings WHERE scunitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVatValue($value)
    {
        $sql = 'DELETE FROM programsettings WHERE vatValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySyncstructure($value)
    {
        $sql = 'DELETE FROM programsettings WHERE syncstructure = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShowPrevPrices($value)
    {
        $sql = 'DELETE FROM programsettings WHERE showPrevPrices = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsOpticProg($value)
    {
        $sql = 'DELETE FROM programsettings WHERE isOpticProg = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReportsPlusHours($value)
    {
        $sql = 'DELETE FROM programsettings WHERE reportsPlusHours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShowM5zon($value)
    {
        $sql = 'DELETE FROM programsettings WHERE showM5zon = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRestaurantStoreId($value)
    {
        $sql = 'DELETE FROM programsettings WHERE restaurantStoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRestuarantPrintTimeout($value)
    {
        $sql = 'DELETE FROM programsettings WHERE restuarantPrintTimeout = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySumSameProductForStore($value)
    {
        $sql = 'DELETE FROM programsettings WHERE sumSameProductForStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEditAllPrice($value)
    {
        $sql = 'DELETE FROM programsettings WHERE editAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsCafe($value)
    {
        $sql = 'DELETE FROM programsettings WHERE isCafe = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsRestaurent($value)
    {
        $sql = 'DELETE FROM programsettings WHERE isRestaurent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductDays($value)
    {
        $sql = 'DELETE FROM programsettings WHERE productDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThereIsRestTax($value)
    {
        $sql = 'DELETE FROM programsettings WHERE thereIsRestTax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRestTaxVal($value)
    {
        $sql = 'DELETE FROM programsettings WHERE restTaxVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRestPrintLang($value)
    {
        $sql = 'DELETE FROM programsettings WHERE restPrintLang = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTaxNameFlag($value)
    {
        $sql = 'DELETE FROM programsettings WHERE taxNameFlag = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcodeDigits($value)
    {
        $sql = 'DELETE FROM programsettings WHERE parcodeDigits = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySpecializedParcodeDigits($value)
    {
        $sql = 'DELETE FROM programsettings WHERE specializedParcodeDigits = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientDefaultDebtLimit($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientDefaultDebtLimit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientDefaultDebtLimitControl($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientDefaultDebtLimitControl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUsedParcode($value)
    {
        $sql = 'DELETE FROM programsettings WHERE usedParcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductbycodeimage($value)
    {
        $sql = 'DELETE FROM programsettings WHERE productbycodeimage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCommentClient($value)
    {
        $sql = 'DELETE FROM programsettings WHERE commentClient = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInventoryevaluation($value)
    {
        $sql = 'DELETE FROM programsettings WHERE Inventoryevaluation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProfitevaluation($value)
    {
        $sql = 'DELETE FROM programsettings WHERE Profitevaluation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelivery($value)
    {
        $sql = 'DELETE FROM programsettings WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPremiums($value)
    {
        $sql = 'DELETE FROM programsettings WHERE premiums = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperationnumEdit($value)
    {
        $sql = 'DELETE FROM programsettings WHERE operationnumEdit = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNoOfDecimalPlaces($value)
    {
        $sql = 'DELETE FROM programsettings WHERE noOfDecimalPlaces = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnReviewBills($value)
    {
        $sql = 'DELETE FROM programsettings WHERE unReviewBills = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnReviewBillsPass($value)
    {
        $sql = 'DELETE FROM programsettings WHERE unReviewBillsPass = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillReviewNote($value)
    {
        $sql = 'DELETE FROM programsettings WHERE billReviewNote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTamweenBakery($value)
    {
        $sql = 'DELETE FROM programsettings WHERE tamweenBakery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCopyRightsStatment($value)
    {
        $sql = 'DELETE FROM programsettings WHERE copyRightsStatment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThreeMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE three_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySixMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE six_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTwelveMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE twelve_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEighteenMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE eighteen_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTwentyfourMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE twentyfour_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThirtyMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE thirty_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySixthirtyMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE sixthirty_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFortytwoMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE fortytwo_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFortyeightMonths($value)
    {
        $sql = 'DELETE FROM programsettings WHERE fortyeight_months = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemoteBackupLink($value)
    {
        $sql = 'DELETE FROM programsettings WHERE remoteBackupLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemoteBackupUser($value)
    {
        $sql = 'DELETE FROM programsettings WHERE remoteBackupUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemoteBackupPass($value)
    {
        $sql = 'DELETE FROM programsettings WHERE remoteBackupPass = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemoteBackupFolder($value)
    {
        $sql = 'DELETE FROM programsettings WHERE remoteBackupFolder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMandobCollectionRatio($value)
    {
        $sql = 'DELETE FROM programsettings WHERE mandobCollectionRatio = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTakeAwayClient($value)
    {
        $sql = 'DELETE FROM programsettings WHERE takeAwayClient = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRestaurantServiceOn($value)
    {
        $sql = 'DELETE FROM programsettings WHERE restaurantServiceOn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEarlyrepayment($value)
    {
        $sql = 'DELETE FROM programsettings WHERE earlyrepayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVisaPay($value)
    {
        $sql = 'DELETE FROM programsettings WHERE visaPay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHeaderPrint($value)
    {
        $sql = 'DELETE FROM programsettings WHERE headerPrint = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHeaderPrintSand($value)
    {
        $sql = 'DELETE FROM programsettings WHERE headerPrintSand = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrintSand($value)
    {
        $sql = 'DELETE FROM programsettings WHERE printSand = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMakeDailyEntry($value)
    {
        $sql = 'DELETE FROM programsettings WHERE makeDailyEntry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientShowTawla($value)
    {
        $sql = 'DELETE FROM programsettings WHERE clientShowTawla = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillRest($value)
    {
        $sql = 'DELETE FROM programsettings WHERE billRest = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySuppIsClientToo($value)
    {
        $sql = 'DELETE FROM programsettings WHERE suppIsClientToo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsCarBill($value)
    {
        $sql = 'DELETE FROM programsettings WHERE isCarBill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensesproduct($value)
    {
        $sql = 'DELETE FROM programsettings WHERE expensesproduct = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProgramsettingsMySql
     */
    protected function readRow($row)
    {
        $programsetting = new Programsetting();

        $programsetting = new Programsetting();

        $programsetting->programsettingsid = isset($row['programsettingsid']) ? $row['programsettingsid'] : '';
        $programsetting->companyname = isset($row['companyname']) ? $row['companyname'] : '';
        $programsetting->address = isset($row['address']) ? $row['address'] : '';
        $programsetting->specializtion = isset($row['specializtion']) ? $row['specializtion'] : '';
        $programsetting->phone = isset($row['phone']) ? $row['phone'] : '';
        $programsetting->faxnumber = isset($row['faxnumber']) ? $row['faxnumber'] : '';
        $programsetting->email = isset($row['email']) ? $row['email'] : '';
        $programsetting->website = isset($row['website']) ? $row['website'] : '';
        $programsetting->logo = isset($row['logo']) ? $row['logo'] : '';
        $programsetting->roundnumbers = isset($row['roundnumbers']) ? $row['roundnumbers'] : '';
        $programsetting->saveprinting = isset($row['saveprinting']) ? $row['saveprinting'] : '';
        $programsetting->deptprinting = isset($row['deptprinting']) ? $row['deptprinting'] : '';
        $programsetting->printingpapersize = isset($row['printingpapersize']) ? $row['printingpapersize'] : '';
        $programsetting->userid = isset($row['userid']) ? $row['userid'] : '';
        $programsetting->showPreviousPrice = isset($row['showPreviousPrice']) ? $row['showPreviousPrice'] : '';
        $programsetting->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $programsetting->priceing = isset($row['priceing']) ? $row['priceing'] : '';
        $programsetting->lastprice = isset($row['lastprice']) ? $row['lastprice'] : '';
        $programsetting->searchvalue = isset($row['searchvalue']) ? $row['searchvalue'] : '';
        $programsetting->clientsearchvalue = isset($row['clientsearchvalue']) ? $row['clientsearchvalue'] : '';
        $programsetting->updateproductprice = isset($row['updateproductprice']) ? $row['updateproductprice'] : '';

        $programsetting->allowfinsldelete = isset($row['allowfinsldelete']) ? $row['allowfinsldelete'] : '';
        $programsetting->updateclientprice = isset($row['updateclientprice']) ? $row['updateclientprice'] : '';
        $programsetting->partition = isset($row['partition']) ? $row['partition'] : '';
        $programsetting->taxcard = isset($row['taxcard']) ? $row['taxcard'] : '';
        $programsetting->commercialregistration = isset($row['commercialregistration']) ? $row['commercialregistration'] : '';
        $programsetting->costcenter = isset($row['costcenter']) ? $row['costcenter'] : '';
        $programsetting->copytype = isset($row['copytype']) ? $row['copytype'] : '';
        $programsetting->clinic = isset($row['clinic']) ? $row['clinic'] : '';
        $programsetting->workshop = isset($row['workshop']) ? $row['workshop'] : '';
        $programsetting->transport = isset($row['transport']) ? $row['transport'] : '';
        $programsetting->manufacturing = isset($row['manufacturing']) ? $row['manufacturing'] : '';
        $programsetting->masterCopy = isset($row['masterCopy']) ? $row['masterCopy'] : '';
        $programsetting->dailyentrydate = isset($row['dailyentrydate']) ? $row['dailyentrydate'] : '';
        $programsetting->updatefiledate = isset($row['updatefiledate']) ? $row['updatefiledate'] : '';

        $programsetting->workerbetweenstores = isset($row['workerbetweenstores']) ? $row['workerbetweenstores'] : '';
        $programsetting->workshoptimeout = isset($row['workshoptimeout']) ? $row['workshoptimeout'] : '';
        $programsetting->drivertimeout = isset($row['drivertimeout']) ? $row['drivertimeout'] : '';
        $programsetting->currancy = isset($row['currancy']) ? $row['currancy'] : '';
        $programsetting->serial = isset($row['serial']) ? $row['serial'] : '';
        $programsetting->allowdateedit = isset($row['allowdateedit']) ? $row['allowdateedit'] : '';


        $programsetting->clientcode = isset($row['clientcode']) ? $row['clientcode'] : '';
        $programsetting->clientserial = isset($row['clientserial']) ? $row['clientserial'] : '';
        $programsetting->timezone = isset($row['timezone']) ? $row['timezone'] : '';
        $programsetting->expiredate = isset($row['expiredate']) ? $row['expiredate'] : '';
        $programsetting->production = isset($row['production']) ? $row['production'] : '';
        $programsetting->description = isset($row['description']) ? $row['description'] : '';
        $programsetting->service = isset($row['service']) ? $row['service'] : '';
        $programsetting->date = isset($row['date']) ? $row['date'] : '';
        $programsetting->limitamount = isset($row['limitamount']) ? $row['limitamount'] : '';
        $programsetting->measuringunit = isset($row['measuringunit']) ? $row['measuringunit'] : '';
        $programsetting->print_amount = isset($row['print_amount']) ? $row['print_amount'] : '';
        $programsetting->billid = isset($row['billid']) ? $row['billid'] : '';
        $programsetting->precentages = isset($row['precentages']) ? $row['precentages'] : '';
        $programsetting->realprice = isset($row['realprice']) ? $row['realprice'] : '';
        $programsetting->delegate_seller = isset($row['delegate_seller']) ? $row['delegate_seller'] : '';
        $programsetting->storeserial = isset($row['storeserial']) ? $row['storeserial'] : '';

        $programsetting->clientfieldrequired = isset($row['clientfieldrequired']) ? $row['clientfieldrequired'] : '';
        $programsetting->clientcodname = isset($row['clientcodname']) ? $row['clientcodname'] : '';
        $programsetting->colortype = isset($row['colortype']) ? $row['colortype'] : '';
        $programsetting->nakdyOnly = isset($row['nakdyOnly']) ? $row['nakdyOnly'] : '';
        $programsetting->nakdyKashf = isset($row['nakdyKashf']) ? $row['nakdyKashf'] : '';
        $programsetting->discount_pres_direct = isset($row['discount_pres_direct']) ? $row['discount_pres_direct'] : '';
        $programsetting->general_discount = isset($row['general_discount']) ? $row['general_discount'] : '';
        $programsetting->sells_return = isset($row['sells_return']) ? $row['sells_return'] : '';
        $programsetting->scunitname = isset($row['scunitname']) ? $row['scunitname'] : '';
        $programsetting->vatValue = isset($row['vatValue']) ? $row['vatValue'] : '';
        $programsetting->syncstructure = isset($row['syncstructure']) ? $row['syncstructure'] : '';
        $programsetting->showPrevPrices = isset($row['showPrevPrices']) ? $row['showPrevPrices'] : '';
        $programsetting->isOpticProg = isset($row['isOpticProg']) ? $row['isOpticProg'] : '';
        $programsetting->reportsPlusHours = isset($row['reportsPlusHours']) ? $row['reportsPlusHours'] : '';
        $programsetting->showM5zon = isset($row['showM5zon']) ? $row['showM5zon'] : '';
        $programsetting->restaurantStoreId = isset($row['restaurantStoreId']) ? $row['restaurantStoreId'] : '';
        $programsetting->restuarantPrintTimeout = isset($row['restuarantPrintTimeout']) ? $row['restuarantPrintTimeout'] : '';
        $programsetting->sumSameProductForStore = isset($row['sumSameProductForStore']) ? $row['sumSameProductForStore'] : '';
        $programsetting->editAllPrice = isset($row['editAllPrice']) ? $row['editAllPrice'] : '';
        $programsetting->isCafe = isset($row['isCafe']) ? $row['isCafe'] : '';
        $programsetting->isRestaurent = isset($row['isRestaurent']) ? $row['isRestaurent'] : '';
        $programsetting->productDays = isset($row['productDays']) ? $row['productDays'] : '';
        $programsetting->thereIsRestTax = isset($row['thereIsRestTax']) ? $row['thereIsRestTax'] : '';
        $programsetting->restTaxVal = isset($row['restTaxVal']) ? $row['restTaxVal'] : '';
        $programsetting->restPrintLang = isset($row['restPrintLang']) ? $row['restPrintLang'] : '';
        $programsetting->taxNameFlag = isset($row['taxNameFlag']) ? $row['taxNameFlag'] : '';
        $programsetting->parcodeDigits = isset($row['parcodeDigits']) ? $row['parcodeDigits'] : '';
        $programsetting->specializedParcodeDigits = isset($row['specializedParcodeDigits']) ? $row['specializedParcodeDigits'] : '';
        $programsetting->clientDefaultDebtLimit = isset($row['clientDefaultDebtLimit']) ? $row['clientDefaultDebtLimit'] : '';
        $programsetting->clientDefaultDebtLimitControl = isset($row['clientDefaultDebtLimitControl']) ? $row['clientDefaultDebtLimitControl'] : '';
        $programsetting->usedParcode = isset($row['usedParcode']) ? $row['usedParcode'] : '';
        $programsetting->productbycodeimage = isset($row['productbycodeimage']) ? $row['productbycodeimage'] : '';
        $programsetting->commentClient = isset($row['commentClient']) ? $row['commentClient'] : '';
        $programsetting->Inventoryevaluation = isset($row['Inventoryevaluation']) ? $row['Inventoryevaluation'] : '';
        $programsetting->Profitevaluation = isset($row['Profitevaluation']) ? $row['Profitevaluation'] : '';
        $programsetting->delivery = isset($row['delivery']) ? $row['delivery'] : '';
        $programsetting->premiums = isset($row['premiums']) ? $row['premiums'] : '';
        $programsetting->operationnumEdit = isset($row['operationnumEdit']) ? $row['operationnumEdit'] : '';
        $programsetting->noOfDecimalPlaces = isset($row['noOfDecimalPlaces']) ? $row['noOfDecimalPlaces'] : '';
        $programsetting->unReviewBills = isset($row['unReviewBills']) ? $row['unReviewBills'] : '';
        $programsetting->unReviewBillsPass = isset($row['unReviewBillsPass']) ? $row['unReviewBillsPass'] : '';
        $programsetting->billReviewNote = isset($row['billReviewNote']) ? $row['billReviewNote'] : '';
        $programsetting->tamweenBakery = isset($row['tamweenBakery']) ? $row['tamweenBakery'] : '';
        $programsetting->three_months = isset($row['three_months']) ? $row['three_months'] : '';
        $programsetting->six_months = isset($row['six_months']) ? $row['six_months'] : '';
        $programsetting->twelve_months = isset($row['twelve_months']) ? $row['twelve_months'] : '';
        $programsetting->eighteen_months = isset($row['eighteen_months']) ? $row['eighteen_months'] : '';
        $programsetting->twentyfour_months = isset($row['twentyfour_months']) ? $row['twentyfour_months'] : '';
        $programsetting->thirty_months = isset($row['thirty_months']) ? $row['thirty_months'] : '';
        $programsetting->sixthirty_months = isset($row['sixthirty_months']) ? $row['sixthirty_months'] : '';
        $programsetting->fortytwo_months = isset($row['fortytwo_months']) ? $row['fortytwo_months'] : '';
        $programsetting->fortyeight_months = isset($row['fortyeight_months']) ? $row['fortyeight_months'] : '';
        $programsetting->mandobCollectionRatio = isset($row['mandobCollectionRatio']) ? $row['mandobCollectionRatio'] : '';
        $programsetting->remoteBackupLink = isset($row['remoteBackupLink']) ? $row['remoteBackupLink'] : '';
        $programsetting->remoteBackupUser = isset($row['remoteBackupUser']) ? $row['remoteBackupUser'] : '';
        //$programsetting->remoteBackupPass = isset($row['remoteBackupPass']) ? $row['remoteBackupPass'] : '';
        $programsetting->remoteBackupFolder = isset($row['remoteBackupFolder']) ? $row['remoteBackupFolder'] : '';
        $programsetting->takeAwayClient = isset($row['takeAwayClient']) ? $row['takeAwayClient'] : '';
        $programsetting->restaurantServiceOn = isset($row['restaurantServiceOn']) ? $row['restaurantServiceOn'] : '';
        $programsetting->earlyrepayment = isset($row['earlyrepayment']) ? $row['earlyrepayment'] : '';
        $programsetting->visaPay = isset($row['visaPay']) ? $row['visaPay'] : '';
        $programsetting->headerPrint = isset($row['headerPrint']) ? $row['headerPrint'] : '';
        $programsetting->headerPrintSand = isset($row['headerPrintSand']) ? $row['headerPrintSand'] : '';
        $programsetting->printSand = isset($row['printSand']) ? $row['printSand'] : '';
        $programsetting->makeDailyEntry = isset($row['makeDailyEntry']) ? $row['makeDailyEntry'] : '';
        $programsetting->clientShowTawla = isset($row['clientShowTawla']) ? $row['clientShowTawla'] : '';
        $programsetting->billRest = isset($row['billRest']) ? $row['billRest'] : '';
        $programsetting->suppIsClientToo = isset($row['suppIsClientToo']) ? $row['suppIsClientToo'] : '';
        $programsetting->isCarBill = isset($row['isCarBill']) ? $row['isCarBill'] : '';
        $programsetting->expensesproduct = isset($row['expensesproduct']) ? $row['expensesproduct'] : '';
        $programsetting->projectshownew = isset($row['projectshownew']) ? $row['projectshownew'] : '';
        $programsetting->showparcode = isset($row['showparcode']) ? $row['showparcode'] : '';
        $programsetting->changeBuyPriceChangeSellInBuyBillCtrl = isset($row['changeBuyPriceChangeSellInBuyBillCtrl']) ? $row['changeBuyPriceChangeSellInBuyBillCtrl'] : '';
        $programsetting->changeBuyPriceChangeSellInProductCtrl = isset($row['changeBuyPriceChangeSellInProductCtrl']) ? $row['changeBuyPriceChangeSellInProductCtrl'] : '';
        $programsetting->inventoryvaluation = isset($row['inventoryvaluation']) ? $row['inventoryvaluation'] : '';
        $programsetting->showBillCollectionSearch = isset($row['showBillCollectionSearch']) ? $row['showBillCollectionSearch'] : '';
        $programsetting->incomeclient = isset($row['incomeclient']) ? $row['incomeclient'] : '';
        $programsetting->showserial = isset($row['showserial']) ? $row['showserial'] : '';
        $programsetting->editservice = isset($row['editservice']) ? $row['editservice'] : '';
        $programsetting->showCurrency = isset($row['showCurrency']) ? $row['showCurrency'] : '';
        $programsetting->qrerp = isset($row['qrerp']) ? $row['qrerp'] : '';
        $programsetting->valueadded = isset($row['valueadded']) ? $row['valueadded'] : '';
        $programsetting->qrcodesh = isset($row['qrcodesh']) ? $row['qrcodesh'] : '';
        $programsetting->printfoot = isset($row['printfoot']) ? $row['printfoot'] : '';
        $programsetting->sellorder = isset($row['sellorder']) ? $row['sellorder'] : '';
        $programsetting->numberprint = isset($row['numberprint']) ? $row['numberprint'] : '';
        $programsetting->valueaddedbuy = isset($row['valueaddedbuy']) ? $row['valueaddedbuy'] : '';
        $programsetting->simpleAddClientInBill = isset($row['simpleAddClientInBill']) ? $row['simpleAddClientInBill'] : '';
        $programsetting->licenseNo = isset($row['licenseNo']) ? $row['licenseNo'] : '';
        $programsetting->maintenance = isset($row['maintenance']) ? $row['maintenance'] : '';
        $programsetting->showPrevDiscount = isset($row['showPrevDiscount']) ? $row['showPrevDiscount'] : '';
        $programsetting->vatvalueqr = isset($row['vatvalueqr']) ? $row['vatvalueqr'] : '';
        $programsetting->imgprinthide = isset($row['imgprinthide']) ? $row['imgprinthide'] : '';
        $programsetting->parcodeprinttype = isset($row['parcodeprinttype']) ? $row['parcodeprinttype'] : '';
        $programsetting->parcodeprintwidth = isset($row['parcodeprintwidth']) ? $row['parcodeprintwidth'] : '';
        $programsetting->parcodeprinttextsize = isset($row['parcodeprinttextsize']) ? $row['parcodeprinttextsize'] : '';
        $programsetting->parcodeprintCurr = isset($row['parcodeprintCurr']) ? $row['parcodeprintCurr'] : '';
        $programsetting->sizecolorDigits = isset($row['sizecolorDigits']) ? $row['sizecolorDigits'] : '';
        $programsetting->searchBarcodeInBill = isset($row['searchBarcodeInBill']) ? $row['searchBarcodeInBill'] : '';
        $programsetting->allowMobileLogin = isset($row['allowMobileLogin']) ? $row['allowMobileLogin'] : '';
        $programsetting->lanAllowType = isset($row['lanAllowType']) ? $row['lanAllowType'] : '';
        $programsetting->wanAllowType = isset($row['wanAllowType']) ? $row['wanAllowType'] : '';
        $programsetting->sendBillToRestaurant = isset($row['sendBillToRestaurant']) ? $row['sendBillToRestaurant'] : '';
        $programsetting->obgyPharmacyGroups = isset($row['obgyPharmacyGroups']) ? $row['obgyPharmacyGroups'] : '';
        $programsetting->updateProUnitPricesOnPriceUpdate = isset($row['updateProUnitPricesOnPriceUpdate']) ? $row['updateProUnitPricesOnPriceUpdate'] : '';
        $programsetting->ebill = isset($row['ebill']) ? $row['ebill'] : '';
        $programsetting->valueaddeddiscount = isset($row['valueaddeddiscount']) ? $row['valueaddeddiscount'] : '';
        $programsetting->clientdetail = isset($row['clientdetail']) ? $row['clientdetail'] : '';
        $programsetting->showPrevPricesRet = isset($row['showPrevPricesRet']) ? $row['showPrevPricesRet'] : '';
        $programsetting->showPrevDiscountRet = isset($row['showPrevDiscountRet']) ? $row['showPrevDiscountRet'] : '';
        $programsetting->eunitInTax = isset($row['eunitInTax']) ? $row['eunitInTax'] : '';
        $programsetting->showStoreToDetail = isset($row['showStoreToDetail']) ? $row['showStoreToDetail'] : '';
        $programsetting->showBuyPriceAtProductddl = isset($row['showBuyPriceAtProductddl']) ? $row['showBuyPriceAtProductddl'] : '';
        $programsetting->specialexpenses = isset($row['specialexpenses']) ? $row['specialexpenses'] : '';
        $programsetting->ratioshow = isset($row['ratioshow']) ? $row['ratioshow'] : '';
        $programsetting->defaultUnitPriceAtBill = isset($row['defaultUnitPriceAtBill']) ? $row['defaultUnitPriceAtBill'] : '';
        $programsetting->rulers = isset($row['rulers']) ? $row['rulers'] : '';
        $programsetting->quantitynew = isset($row['quantitynew']) ? $row['quantitynew'] : '';
        $programsetting->showBillOperationSearch = isset($row['showBillOperationSearch']) ? $row['showBillOperationSearch'] : '';
        $programsetting->obygyFolder = isset($row['obygyFolder']) ? $row['obygyFolder'] : '';
        $programsetting->clientsell = isset($row['clientsell']) ? $row['clientsell'] : '';
        $programsetting->preorderperiod = isset($row['preorderperiod']) ? $row['preorderperiod'] : '';
        $programsetting->useListPrice = isset($row['useListPrice']) ? $row['useListPrice'] : '';
        $programsetting->ebillclient = isset($row['ebillclient']) ? $row['ebillclient'] : '';
        $programsetting->importproduct = isset($row['importproduct']) ? $row['importproduct'] : '';
        $programsetting->realestateunits = isset($row['realestateunits']) ? $row['realestateunits'] : '';
        $programsetting->expensesupplier = isset($row['expensesupplier']) ? $row['expensesupplier'] : '';
        $programsetting->changeOrderproduct = isset($row['changeOrderproduct']) ? $row['changeOrderproduct'] : '';
        $programsetting->searchlimit = isset($row['searchlimit']) ? $row['searchlimit'] : '';
        $programsetting->typebill = isset($row['typebill']) ? $row['typebill'] : '';
        $programsetting->roundnumbersbilltotal = isset($row['roundnumbersbilltotal']) ? $row['roundnumbersbilltotal'] : '';
        $programsetting->noOfDecimalPlacesBillTotal = isset($row['noOfDecimalPlacesBillTotal']) ? $row['noOfDecimalPlacesBillTotal'] : '';
        $programsetting->dailyEntryCostprice = isset($row['dailyEntryCostprice']) ? $row['dailyEntryCostprice'] : '';
        $programsetting->storeRecieveType = isset($row['storeRecieveType']) ? $row['storeRecieveType'] : '';
        $programsetting->clientPhoneReq = isset($row['clientPhoneReq']) ? $row['clientPhoneReq'] : '';
        $programsetting->addServiceToBill = isset($row['addServiceToBill']) ? $row['addServiceToBill'] : '';
        $programsetting->realestatedev = isset($row['realestatedev']) ? $row['realestatedev'] : '';
        $programsetting->showprice4 = isset($row['showprice4']) ? $row['showprice4'] : '';
        $programsetting->showprice5 = isset($row['showprice5']) ? $row['showprice5'] : '';
        $programsetting->showprice6 = isset($row['showprice6']) ? $row['showprice6'] : '';
        $programsetting->showprice7 = isset($row['showprice7']) ? $row['showprice7'] : '';
        $programsetting->showprice8 = isset($row['showprice8']) ? $row['showprice8'] : '';
        $programsetting->showpriceall = isset($row['showpriceall']) ? $row['showpriceall'] : '';
        $programsetting->showpricehalf = isset($row['showpricehalf']) ? $row['showpricehalf'] : '';
        $programsetting->showpriceunit = isset($row['showpriceunit']) ? $row['showpriceunit'] : '';
        $programsetting->showbillstatus = isset($row['showbillstatus']) ? $row['showbillstatus'] : '';
        $programsetting->showbilldeliverydate = isset($row['showbilldeliverydate']) ? $row['showbilldeliverydate'] : '';
        $programsetting->enablequantityfractions = isset($row['enablequantityfractions']) ? $row['enablequantityfractions'] : '';
        $programsetting->addclienttoproduct = isset($row['addclienttoproduct']) ? $row['addclienttoproduct'] : '';
        $programsetting->closingcustomeraccount = isset($row['closingcustomeraccount']) ? $row['closingcustomeraccount'] : '';
        $programsetting->serial2 = isset($row['serial2']) ? $row['serial2'] : '';
        $programsetting->shownameE = isset($row['shownameE']) ? $row['shownameE'] : '';
        $programsetting->showprocode = isset($row['showprocode']) ? $row['showprocode'] : '';
        $programsetting->showpartnumber = isset($row['showpartnumber']) ? $row['showpartnumber'] : '';
        $programsetting->showtype = isset($row['showtype']) ? $row['showtype'] : '';
        $programsetting->showcompany = isset($row['showcompany']) ? $row['showcompany'] : '';
        $programsetting->showweight = isset($row['showweight']) ? $row['showweight'] : '';
        $programsetting->showorigin = isset($row['showorigin']) ? $row['showorigin'] : '';
        $programsetting->showhscode = isset($row['showhscode']) ? $row['showhscode'] : '';
        $programsetting->showexpire = isset($row['showexpire']) ? $row['showexpire'] : '';
        $programsetting->showgrantduration = isset($row['showgrantduration']) ? $row['showgrantduration'] : '';
        $programsetting->showonline = isset($row['showonline']) ? $row['showonline'] : '';
        $programsetting->showminappear = isset($row['showminappear']) ? $row['showminappear'] : '';
        $programsetting->showonlinecat = isset($row['showonlinecat']) ? $row['showonlinecat'] : '';
        $programsetting->showsellpercentage = isset($row['showsellpercentage']) ? $row['showsellpercentage'] : '';
        $programsetting->showbuydiscount = isset($row['showbuydiscount']) ? $row['showbuydiscount'] : '';
        $programsetting->preparingStore = isset($row['preparingStore']) ? $row['preparingStore'] : '';
        $programsetting->sellordername = isset($row['sellordername']) ? $row['sellordername'] : '';
        $programsetting->showsearchfilter = isset($row['showsearchfilter']) ? $row['showsearchfilter'] : '';
        $programsetting->unitPriceAtsalesreport = isset($row['unitPriceAtsalesreport']) ? $row['unitPriceAtsalesreport'] : '';
        $programsetting->medExCat = isset($row['medExCat']) ? $row['medExCat'] : '';
        $programsetting->laterNakdiClientId = isset($row['laterNakdiClientId']) ? $row['laterNakdiClientId'] : '';
        $programsetting->headerPrint12Right = isset($row['headerPrint12Right']) ? $row['headerPrint12Right'] : '';
        $programsetting->headerPrint12Left = isset($row['headerPrint12Left']) ? $row['headerPrint12Left'] : '';
        $programsetting->halfPriceStart = isset($row['halfPriceStart']) ? $row['halfPriceStart'] : '';
        $programsetting->allPriceStart = isset($row['allPriceStart']) ? $row['allPriceStart'] : '';
        $programsetting->checkretsellclient = isset($row['checkretsellclient']) ? $row['checkretsellclient'] : '';


        return $programsetting;

        return $programsetting;
    }

    protected function getList($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProgramsettingsMySql
     */
    protected function getRow($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery)
    {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery)
    {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery)
    {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery)
    {
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
