<?php

/**
 * Class that operate on table 'projectexchmaterialreturn'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-03 12:01
 */
class ProjectexchmaterialreturnMySqlDAO implements ProjectexchmaterialreturnDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProjectexchmaterialreturnMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM projectexchmaterialreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM projectexchmaterialreturn ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param projectexchmaterialreturn primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProjectexchmaterialreturnMySql projectexchmaterialreturn
     */
    public function insert($projectexchmaterialreturn) {
        $sql = 'INSERT INTO projectexchmaterialreturn (serilno, projectid, storeid, projdate, sysdate, totalnum, totalbuyprice, entryid,userid,supervision_type,supervision_amount,supplierid,finalsupervision) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($projectexchmaterialreturn->serilno);
        $sqlQuery->setNumber($projectexchmaterialreturn->projectid);
        $sqlQuery->setNumber($projectexchmaterialreturn->storeid);
        $sqlQuery->set($projectexchmaterialreturn->projdate);
        $sqlQuery->set($projectexchmaterialreturn->sysdate);
        $sqlQuery->set($projectexchmaterialreturn->totalnum);
        $sqlQuery->set($projectexchmaterialreturn->totalbuyprice);
        $sqlQuery->setNumber($projectexchmaterialreturn->entryid);
        $sqlQuery->setNumber($projectexchmaterialreturn->userid);
        $sqlQuery->set($projectexchmaterialreturn->supervision_type);
        $sqlQuery->set($projectexchmaterialreturn->supervision_amount);
        $sqlQuery->setNumber($projectexchmaterialreturn->supplierid);
        $sqlQuery->setNumber($projectexchmaterialreturn->finalsupervision);

        $id = $this->executeInsert($sqlQuery);
        $projectexchmaterialreturn->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProjectexchmaterialreturnMySql projectexchmaterialreturn
     */
    public function update($projectexchmaterialreturn) {
        $sql = 'UPDATE projectexchmaterialreturn SET serilno = ?, projectid = ?, storeid = ?, projdate = ?, sysdate = ?, totalnum = ?, totalbuyprice = ?, entryid = ?, userid = ?, supervision_type = ?, supervision_amount = ?, supplierid = ?, finalsupervision = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($projectexchmaterialreturn->serilno);
        $sqlQuery->setNumber($projectexchmaterialreturn->projectid);
        $sqlQuery->setNumber($projectexchmaterialreturn->storeid);
        $sqlQuery->set($projectexchmaterialreturn->projdate);
        $sqlQuery->set($projectexchmaterialreturn->sysdate);
        $sqlQuery->set($projectexchmaterialreturn->totalnum);
        $sqlQuery->set($projectexchmaterialreturn->totalbuyprice);
        $sqlQuery->setNumber($projectexchmaterialreturn->entryid);
        $sqlQuery->setNumber($projectexchmaterialreturn->userid);
        $sqlQuery->set($projectexchmaterialreturn->supervision_type);
        $sqlQuery->set($projectexchmaterialreturn->supervision_amount);
        $sqlQuery->setNumber($projectexchmaterialreturn->supplierid);
        $sqlQuery->setNumber($projectexchmaterialreturn->finalsupervision);

        $sqlQuery->setNumber($projectexchmaterialreturn->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM projectexchmaterialreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySerilno($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE serilno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjectid($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjdate($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE projdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalnum($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE totalnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalbuyprice($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE totalbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEntryid($value) {
        $sql = 'SELECT * FROM projectexchmaterialreturn WHERE entryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySerilno($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE serilno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjectid($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjdate($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE projdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalnum($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE totalnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalbuyprice($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE totalbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEntryid($value) {
        $sql = 'DELETE FROM projectexchmaterialreturn WHERE entryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProjectexchmaterialreturnMySql
     */
    protected function readRow($row) {
        $projectexchmaterialreturn = new Projectexchmaterialreturn();

        $projectexchmaterialreturn->id = isset($row['id']) ? $row['id'] : '';
        $projectexchmaterialreturn->serilno = isset($row['serilno']) ? $row['serilno'] : '';
        $projectexchmaterialreturn->projectid = isset($row['projectid']) ? $row['projectid'] : '';
        $projectexchmaterialreturn->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $projectexchmaterialreturn->projdate = isset($row['projdate']) ? $row['projdate'] : '';
        $projectexchmaterialreturn->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $projectexchmaterialreturn->totalnum = isset($row['totalnum']) ? $row['totalnum'] : '';
        $projectexchmaterialreturn->totalbuyprice = isset($row['totalbuyprice']) ? $row['totalbuyprice'] : '';
        $projectexchmaterialreturn->entryid = isset($row['entryid']) ? $row['entryid'] : '';
        $projectexchmaterialreturn->userid = isset($row['userid']) ? $row['userid'] : '';
        $projectexchmaterialreturn->supervision_type = isset($row['supervision_type']) ? $row['supervision_type'] : '';
        $projectexchmaterialreturn->supervision_amount = isset($row['supervision_amount']) ? $row['supervision_amount'] : '';
        $projectexchmaterialreturn->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $projectexchmaterialreturn->finalsupervision = isset($row['finalsupervision']) ? $row['finalsupervision'] : '';

        return $projectexchmaterialreturn;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProjectexchmaterialreturnMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>