<?php

/**
 * Class that operate on table 'quickprofitclient'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
class QuickprofitclientMySqlDAO implements QuickprofitclientDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return QuickprofitclientMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM quickprofitclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM quickprofitclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM quickprofitclient ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param quickprofitclient primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM quickprofitclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param QuickprofitclientMySql quickprofitclient
     */
    public function insert($quickprofitclient) {
        $sql = 'INSERT INTO quickprofitclient (clientId, theDate, sellVal, sellCostBuyPrice, sellCostLastBuyPrice, sellCostMeanBuyPrice, sellCostLastBuyPricewithDiscount, sellCostMeanBuyPricewithDiscount, returnSellVal, returnSellCostBuyPrice, returnSellCostLastBuyPrice, returnSellCostMeanBuyPrice, returnSellCostLastBuyPricewithDiscount, returnSellCostMeanBuyPricewithDiscount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitclient->clientId);
        $sqlQuery->set($quickprofitclient->theDate);
        $sqlQuery->set($quickprofitclient->sellVal);
        $sqlQuery->set($quickprofitclient->sellCostBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->returnSellVal);
        $sqlQuery->set($quickprofitclient->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->returnSellCostMeanBuyPricewithDiscount);

        $id = $this->executeInsert($sqlQuery);
        $quickprofitclient->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param QuickprofitclientMySql quickprofitclient
     */
    public function update($quickprofitclient) {
        $sql = 'UPDATE quickprofitclient SET clientId = ?, theDate = ?, sellVal = ?, sellCostBuyPrice = ?, sellCostLastBuyPrice = ?, sellCostMeanBuyPrice = ?, sellCostLastBuyPricewithDiscount = ?, sellCostMeanBuyPricewithDiscount = ?, returnSellVal = ?, returnSellCostBuyPrice = ?, returnSellCostLastBuyPrice = ?, returnSellCostMeanBuyPrice = ?, returnSellCostLastBuyPricewithDiscount = ?, returnSellCostMeanBuyPricewithDiscount = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitclient->clientId);
        $sqlQuery->set($quickprofitclient->theDate);
        $sqlQuery->set($quickprofitclient->sellVal);
        $sqlQuery->set($quickprofitclient->sellCostBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitclient->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->returnSellVal);
        $sqlQuery->set($quickprofitclient->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitclient->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitclient->returnSellCostMeanBuyPricewithDiscount);

        $sqlQuery->setNumber($quickprofitclient->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM quickprofitclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientId($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellVal($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellVal($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitclient WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientId($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellVal($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellVal($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitclient WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return QuickprofitclientMySql
     */
    protected function readRow($row) {
        $quickprofitclient = new Quickprofitclient();

        $quickprofitclient->id = $row['id'];
        $quickprofitclient->clientId = $row['clientId'];
        $quickprofitclient->theDate = $row['theDate'];
        $quickprofitclient->sellVal = $row['sellVal'];
        $quickprofitclient->sellCostBuyPrice = $row['sellCostBuyPrice'];
        $quickprofitclient->sellCostLastBuyPrice = $row['sellCostLastBuyPrice'];
        $quickprofitclient->sellCostMeanBuyPrice = $row['sellCostMeanBuyPrice'];
        $quickprofitclient->sellCostLastBuyPricewithDiscount = $row['sellCostLastBuyPricewithDiscount'];
        $quickprofitclient->sellCostMeanBuyPricewithDiscount = $row['sellCostMeanBuyPricewithDiscount'];
        $quickprofitclient->sellCostOverAllAveragePrice = $row['sellCostOverAllAveragePrice'];
        $quickprofitclient->returnSellVal = $row['returnSellVal'];
        $quickprofitclient->returnSellCostBuyPrice = $row['returnSellCostBuyPrice'];
        $quickprofitclient->returnSellCostLastBuyPrice = $row['returnSellCostLastBuyPrice'];
        $quickprofitclient->returnSellCostMeanBuyPrice = $row['returnSellCostMeanBuyPrice'];
        $quickprofitclient->returnSellCostLastBuyPricewithDiscount = $row['returnSellCostLastBuyPricewithDiscount'];
        $quickprofitclient->returnSellCostMeanBuyPricewithDiscount = $row['returnSellCostMeanBuyPricewithDiscount'];
        $quickprofitclient->returnSellCostOverAllAveragePrice = $row['returnSellCostOverAllAveragePrice'];
        //
        $quickprofitclient->clientname = $row['clientname'];
        $quickprofitclient->areaName = $row['areaName'];

        return $quickprofitclient;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return QuickprofitclientMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>