<?php

/**
 * Class that operate on table 'stage'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 10:32
 */
class StageMySqlDAO implements StageDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StageMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM stage WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM stage';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM stage ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param stage primary key
     */
    public function delete($stageId) {
        $sql = 'DELETE FROM stage WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($stageId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StageMySql stage
     */
    public function insert($stage) {
        $sql = 'INSERT INTO stage (stagename, productId, totalhour, userid, conditions, date) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($stage->stagename);
        $sqlQuery->setNumber($stage->productId);
        $sqlQuery->set($stage->totalhour);
        $sqlQuery->setNumber($stage->userid);
        $sqlQuery->setNumber($stage->conditions);
        $sqlQuery->set($stage->date);

        $id = $this->executeInsert($sqlQuery);
        $stage->stageId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StageMySql stage
     */
    public function update($stage) {
        $sql = 'UPDATE stage SET stagename = ?, productId = ?, totalhour = ?, userid = ?, conditions = ?, date = ? WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($stage->stagename);
        $sqlQuery->setNumber($stage->productId);
        $sqlQuery->set($stage->totalhour);
        $sqlQuery->setNumber($stage->userid);
        $sqlQuery->setNumber($stage->conditions);
        $sqlQuery->set($stage->date);

        $sqlQuery->setNumber($stage->stageId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM stage';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStagename($value) {
        $sql = 'SELECT * FROM stage WHERE stagename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM stage WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalhour($value) {
        $sql = 'SELECT * FROM stage WHERE totalhour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM stage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM stage WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDate($value) {
        $sql = 'SELECT * FROM stage WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStagename($value) {
        $sql = 'DELETE FROM stage WHERE stagename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM stage WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalhour($value) {
        $sql = 'DELETE FROM stage WHERE totalhour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM stage WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM stage WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDate($value) {
        $sql = 'DELETE FROM stage WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StageMySql
     */
    protected function readRow($row) {
        $stage = new Stage();

        $stage->stageId = isset($row['stageId']) ? $row['stageId'] : '';
        $stage->stagename = isset($row['stagename']) ? $row['stagename'] : '';
        $stage->productId = isset($row['productId']) ? $row['productId'] : '';
        $stage->totalhour = isset($row['totalhour']) ? $row['totalhour'] : '';
        $stage->userid = isset($row['userid']) ? $row['userid'] : '';
        $stage->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $stage->date = isset($row['date']) ? $row['date'] : '';

        return $stage;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StageMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>