<?php

/**
 * Class that operate on table 'supplieropendebtchange'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-20 15:34
 */
class SupplieropendebtchangeMySqlDAO implements SupplieropendebtchangeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplieropendebtchangeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplieropendebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supplieropendebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supplieropendebtchange ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supplieropendebtchange primary key
     */
    public function delete($supplieropendebtchangeid) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplieropendebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($supplieropendebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplieropendebtchangeMySql supplieropendebtchange
     */
    public function insert($supplieropendebtchange) {
        $sql = 'INSERT INTO supplieropendebtchange (opensupplierid, supplierdebtchangebefore, supplierdebtchangeamount, supplierdebtchangetype, processname, supplierdebtchangemodelid, supplierdebtchangeafter, supplierdebtchangedate, userid, tablename, comment, del, dailyentryid, saveid, costcenterid, currencyId, conversionFactor, payedInCurrency, saveConversionFactor) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplieropendebtchange->opensupplierid);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangebefore);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangeamount);
        $sqlQuery->setNumber($supplieropendebtchange->supplierdebtchangetype);
        $sqlQuery->set($supplieropendebtchange->processname);
        $sqlQuery->setNumber($supplieropendebtchange->supplierdebtchangemodelid);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangeafter);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangedate);
        $sqlQuery->setNumber($supplieropendebtchange->userid);
        $sqlQuery->set($supplieropendebtchange->tablename);
        $sqlQuery->setString2($supplieropendebtchange->comment);
        $sqlQuery->setNumber($supplieropendebtchange->del);
        $sqlQuery->setNumber($supplieropendebtchange->dailyentryid);
        $sqlQuery->setNumber($supplieropendebtchange->saveid);
        $sqlQuery->setNumber($supplieropendebtchange->costcenterid);
        $sqlQuery->setNumber($supplieropendebtchange->currencyId);
        $sqlQuery->set($supplieropendebtchange->conversionFactor);
        $sqlQuery->set($supplieropendebtchange->payedInCurrency);
        $sqlQuery->set($supplieropendebtchange->saveConversionFactor);

        $id = $this->executeInsert($sqlQuery);
        $supplieropendebtchange->supplieropendebtchangeid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplieropendebtchangeMySql supplieropendebtchange
     */
    public function update($supplieropendebtchange) {
        $sql = 'UPDATE supplieropendebtchange SET opensupplierid = ?, supplierdebtchangebefore = ?, supplierdebtchangeamount = ?, supplierdebtchangetype = ?, processname = ?, supplierdebtchangemodelid = ?, supplierdebtchangeafter = ?, supplierdebtchangedate = ?, userid = ?, tablename = ?, comment = ?, del = ?, dailyentryid = ?, saveid = ?, costcenterid = ?, currencyId = ?, conversionFactor = ?, payedInCurrency = ?, saveConversionFactor = ? WHERE supplieropendebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplieropendebtchange->opensupplierid);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangebefore);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangeamount);
        $sqlQuery->setNumber($supplieropendebtchange->supplierdebtchangetype);
        $sqlQuery->set($supplieropendebtchange->processname);
        $sqlQuery->setNumber($supplieropendebtchange->supplierdebtchangemodelid);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangeafter);
        $sqlQuery->set($supplieropendebtchange->supplierdebtchangedate);
        $sqlQuery->setNumber($supplieropendebtchange->userid);
        $sqlQuery->set($supplieropendebtchange->tablename);
        $sqlQuery->setString2($supplieropendebtchange->comment);
        $sqlQuery->setNumber($supplieropendebtchange->del);
        $sqlQuery->setNumber($supplieropendebtchange->dailyentryid);
        $sqlQuery->setNumber($supplieropendebtchange->saveid);
        $sqlQuery->setNumber($supplieropendebtchange->costcenterid);
        $sqlQuery->setNumber($supplieropendebtchange->currencyId);
        $sqlQuery->set($supplieropendebtchange->conversionFactor);
        $sqlQuery->set($supplieropendebtchange->payedInCurrency);
        $sqlQuery->set($supplieropendebtchange->saveConversionFactor);

        $sqlQuery->setNumber($supplieropendebtchange->supplieropendebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supplieropendebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOpensupplierid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE opensupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangebefore($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangeamount($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangetype($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangemodelid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangeafter($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangedate($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE supplierdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrencyId($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE currencyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConversionFactor($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayedInCurrency($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE payedInCurrency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveConversionFactor($value) {
        $sql = 'SELECT * FROM supplieropendebtchange WHERE saveConversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOpensupplierid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE opensupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangebefore($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangeamount($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangetype($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangemodelid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangeafter($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangedate($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE supplierdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrencyId($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE currencyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConversionFactor($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayedInCurrency($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE payedInCurrency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveConversionFactor($value) {
        $sql = 'DELETE FROM supplieropendebtchange WHERE saveConversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplieropendebtchangeMySql
     */
    protected function readRow($row) {
        $supplieropendebtchange = new Supplieropendebtchange();

        $supplieropendebtchange->supplieropendebtchangeid = $row['supplieropendebtchangeid'];
        $supplieropendebtchange->opensupplierid = $row['opensupplierid'];
        $supplieropendebtchange->supplierdebtchangebefore = $row['supplierdebtchangebefore'];
        $supplieropendebtchange->supplierdebtchangeamount = $row['supplierdebtchangeamount'];
        $supplieropendebtchange->supplierdebtchangetype = $row['supplierdebtchangetype'];
        $supplieropendebtchange->processname = $row['processname'];
        $supplieropendebtchange->supplierdebtchangemodelid = $row['supplierdebtchangemodelid'];
        $supplieropendebtchange->supplierdebtchangeafter = $row['supplierdebtchangeafter'];
        $supplieropendebtchange->supplierdebtchangedate = $row['supplierdebtchangedate'];
        $supplieropendebtchange->userid = $row['userid'];
        $supplieropendebtchange->tablename = $row['tablename'];
        $supplieropendebtchange->comment = $row['comment'];
        $supplieropendebtchange->del = $row['del'];
        $supplieropendebtchange->dailyentryid = $row['dailyentryid'];
        $supplieropendebtchange->saveid = $row['saveid'];
        $supplieropendebtchange->costcenterid = $row['costcenterid'];
        $supplieropendebtchange->currencyId = $row['currencyId'];
        $supplieropendebtchange->conversionFactor = $row['conversionFactor'];
        $supplieropendebtchange->payedInCurrency = $row['payedInCurrency'];
        $supplieropendebtchange->saveConversionFactor = $row['saveConversionFactor'];
        //
        $supplieropendebtchange->suppOpenName = $row['suppOpenName'];

        return $supplieropendebtchange;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplieropendebtchangeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>