<?php

/**
 * Class that operate on table 'taskorderproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-18 12:20
 */
class TaskorderproductsMySqlDAO implements TaskorderproductsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TaskorderproductsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM taskorderproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM taskorderproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM taskorderproducts ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param taskorderproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM taskorderproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TaskorderproductsMySql taskorderproduct
     */
    public function insert($taskorderproduct) {
        $sql = 'INSERT INTO taskorderproducts (taskorderid, productid, unitid, quantity) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($taskorderproduct->taskorderid);
        $sqlQuery->setNumber($taskorderproduct->productid);
        $sqlQuery->setNumber($taskorderproduct->unitid);
        $sqlQuery->setNumber($taskorderproduct->quantity);

        $id = $this->executeInsert($sqlQuery);
        $taskorderproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TaskorderproductsMySql taskorderproduct
     */
    public function update($taskorderproduct) {
        $sql = 'UPDATE taskorderproducts SET taskorderid = ?, productid = ?, unitid = ?, quantity = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($taskorderproduct->taskorderid);
        $sqlQuery->setNumber($taskorderproduct->productid);
        $sqlQuery->setNumber($taskorderproduct->unitid);
        $sqlQuery->setNumber($taskorderproduct->quantity);

        $sqlQuery->setNumber($taskorderproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM taskorderproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTaskorderid($value) {
        $sql = 'SELECT * FROM taskorderproducts WHERE taskorderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM taskorderproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM taskorderproducts WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM taskorderproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTaskorderid($value) {
        $sql = 'DELETE FROM taskorderproducts WHERE taskorderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM taskorderproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM taskorderproducts WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM taskorderproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TaskorderproductsMySql
     */
    protected function readRow($row) {
        $taskorderproduct = new Taskorderproduct();

        $taskorderproduct->id = $row['id'];
        $taskorderproduct->taskorderid = $row['taskorderid'];
        $taskorderproduct->productid = $row['productid'];
        $taskorderproduct->unitid = $row['unitid'];
        $taskorderproduct->quantity = isset($row['quantity']) ? (float) $row['quantity'] : '';

        $taskorderproduct->productName = $row['productName'];
        $taskorderproduct->unitName = $row['unitName'];
        $taskorderproduct->productBuyPrice = $row['productBuyPrice'];
        $taskorderproduct->productnumber = $row['productnumber'];

        return $taskorderproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TaskorderproductsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>