<?php

/**
 * Class that operate on table 'toworkshoporder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-26 14:08
 */
class ToworkshoporderMySqlDAO implements ToworkshoporderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ToworkshoporderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM toworkshoporder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM toworkshoporder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM toworkshoporder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param toworkshoporder primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM toworkshoporder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ToworkshoporderMySql toworkshoporder
     */
    public function insert($toworkshoporder) {
        $sql = 'INSERT INTO toworkshoporder (driverIdBack,deliverIdBack,orderNo, driverId, workshopId, productNo, deliverWorkshopDate, deliverId, branchId, orderStatus, sysDate, del, userid, recieveWorkshopDate, deliverBranchDate, recieveBranchDate,drivertimeout,driverdelay,workshoptimeout,workshopdelay,drivertimeoutback,driverdelayback) VALUES (?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($toworkshoporder->driverIdBack);
        $sqlQuery->setNumber($toworkshoporder->deliverIdBack);
        $sqlQuery->set($toworkshoporder->orderNo);
        $sqlQuery->setNumber($toworkshoporder->driverId);
        $sqlQuery->setNumber($toworkshoporder->workshopId);
        $sqlQuery->setNumber($toworkshoporder->productNo);
        $sqlQuery->set($toworkshoporder->deliverWorkshopDate);
        $sqlQuery->setNumber($toworkshoporder->deliverId);
        $sqlQuery->setNumber($toworkshoporder->branchId);
        $sqlQuery->setNumber($toworkshoporder->orderStatus);
        $sqlQuery->set($toworkshoporder->sysDate);
        $sqlQuery->setNumber($toworkshoporder->del);
        $sqlQuery->setNumber($toworkshoporder->userid);
        $sqlQuery->set($toworkshoporder->recieveWorkshopDate);
        $sqlQuery->set($toworkshoporder->deliverBranchDate);
        $sqlQuery->set($toworkshoporder->recieveBranchDate);

        $sqlQuery->setNumber($toworkshoporder->drivertimeout);
        $sqlQuery->setNumber($toworkshoporder->driverdelay);
        $sqlQuery->setNumber($toworkshoporder->workshoptimeout);
        $sqlQuery->setNumber($toworkshoporder->workshopdelay);
        $sqlQuery->setNumber($toworkshoporder->drivertimeoutback);
        $sqlQuery->setNumber($toworkshoporder->driverdelayback);

        $id = $this->executeInsert($sqlQuery);
        $toworkshoporder->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ToworkshoporderMySql toworkshoporder
     */
    public function update($toworkshoporder) {
        $sql = 'UPDATE toworkshoporder SET driverIdBack = ?,deliverIdBack = ?, orderNo = ?, driverId = ?, workshopId = ?, productNo = ?, deliverWorkshopDate = ?, deliverId = ?, branchId = ?, orderStatus = ?, sysDate = ?, del = ?, userid = ?, recieveWorkshopDate = ?, deliverBranchDate = ?, recieveBranchDate = ? ,drivertimeout = ?,driverdelay = ?,workshoptimeout = ?,workshopdelay = ?,drivertimeoutback = ?,driverdelayback = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($toworkshoporder->driverIdBack);
        $sqlQuery->setNumber($toworkshoporder->deliverIdBack);
        $sqlQuery->set($toworkshoporder->orderNo);
        $sqlQuery->setNumber($toworkshoporder->driverId);
        $sqlQuery->setNumber($toworkshoporder->workshopId);
        $sqlQuery->setNumber($toworkshoporder->productNo);
        $sqlQuery->set($toworkshoporder->deliverWorkshopDate);
        $sqlQuery->setNumber($toworkshoporder->deliverId);
        $sqlQuery->setNumber($toworkshoporder->branchId);
        $sqlQuery->setNumber($toworkshoporder->orderStatus);
        $sqlQuery->set($toworkshoporder->sysDate);
        $sqlQuery->setNumber($toworkshoporder->del);
        $sqlQuery->setNumber($toworkshoporder->userid);
        $sqlQuery->set($toworkshoporder->recieveWorkshopDate);
        $sqlQuery->set($toworkshoporder->deliverBranchDate);
        $sqlQuery->set($toworkshoporder->recieveBranchDate);

        $sqlQuery->setNumber($toworkshoporder->drivertimeout);
        $sqlQuery->setNumber($toworkshoporder->driverdelay);
        $sqlQuery->setNumber($toworkshoporder->workshoptimeout);
        $sqlQuery->setNumber($toworkshoporder->workshopdelay);
        $sqlQuery->setNumber($toworkshoporder->drivertimeoutback);
        $sqlQuery->setNumber($toworkshoporder->driverdelayback);

        $sqlQuery->setNumber($toworkshoporder->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM toworkshoporder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderNo($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE orderNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDriverId($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE driverId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkshopId($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE workshopId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductNo($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE productNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeliverWorkshopDate($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE deliverWorkshopDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeliverId($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE deliverId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderStatus($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE orderStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM toworkshoporder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderNo($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE orderNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDriverId($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE driverId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkshopId($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE workshopId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductNo($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE productNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeliverWorkshopDate($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE deliverWorkshopDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeliverId($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE deliverId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderStatus($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE orderStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM toworkshoporder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ToworkshoporderMySql
     */
    protected function readRow($row) {
        $toworkshoporder = new Toworkshoporder();

        $toworkshoporder->id = isset($row['id']) ? $row['id'] : '';
        $toworkshoporder->driverIdBack = isset($row['driverIdBack']) ? $row['driverIdBack'] : '';
        $toworkshoporder->deliverIdBack = isset($row['deliverIdBack']) ? $row['deliverIdBack'] : '';
        $toworkshoporder->orderNo = isset($row['orderNo']) ? $row['orderNo'] : '';
        $toworkshoporder->driverId = isset($row['driverId']) ? $row['driverId'] : '';
        $toworkshoporder->workshopId = isset($row['workshopId']) ? $row['workshopId'] : '';
        $toworkshoporder->productNo = isset($row['productNo']) ? $row['productNo'] : '';
        $toworkshoporder->deliverWorkshopDate = isset($row['deliverWorkshopDate']) ? $row['deliverWorkshopDate'] : '';
        $toworkshoporder->deliverId = isset($row['deliverId']) ? $row['deliverId'] : '';
        $toworkshoporder->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $toworkshoporder->orderStatus = isset($row['orderStatus']) ? $row['orderStatus'] : '';
        $toworkshoporder->sysDate = isset($row['sysDate']) ? $row['sysDate'] : '';
        $toworkshoporder->del = isset($row['del']) ? $row['del'] : '';
        $toworkshoporder->userid = isset($row['userid']) ? $row['userid'] : '';

        $toworkshoporder->recieveWorkshopDate = isset($row['recieveWorkshopDate']) ? $row['recieveWorkshopDate'] : '';
        $toworkshoporder->deliverBranchDate = isset($row['deliverBranchDate']) ? $row['deliverBranchDate'] : '';
        $toworkshoporder->recieveBranchDate = isset($row['recieveBranchDate']) ? $row['recieveBranchDate'] : '';

        $toworkshoporder->drivertimeout = isset($row['drivertimeout']) ? $row['drivertimeout'] : '';
        $toworkshoporder->driverdelay = isset($row['driverdelay']) ? $row['driverdelay'] : '';
        $toworkshoporder->workshoptimeout = isset($row['workshoptimeout']) ? $row['workshoptimeout'] : '';
        $toworkshoporder->workshopdelay = isset($row['workshopdelay']) ? $row['workshopdelay'] : '';
        $toworkshoporder->drivertimeoutback = isset($row['drivertimeoutback']) ? $row['drivertimeoutback'] : '';
        $toworkshoporder->driverdelayback = isset($row['driverdelayback']) ? $row['driverdelayback'] : '';

        return $toworkshoporder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ToworkshoporderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>