<?php

/**
 * Class that operate on table 'policy'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 10:48
 */
class PolicyMySqlExtDAO extends PolicyMySqlDAO {

    public function queryWithOrder() {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where  shippercompanies.tempdele = 0 and policy.tempdele = 0
		 order by policyId desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOrderLimited($start, $end) {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where  shippercompanies.tempdele = 0 and policy.tempdele = 0
		 order by policyId desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithCompanyId($companyId) {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where policy.companyId = ' . $companyId . '
		  and  shippercompanies.tempdele = 0 and policy.tempdele = 0
		 order by policyId desc';

        // print_r("<br>".$sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithType($type) {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where policy.senderType = ' . $type . '
		  and  shippercompanies.tempdele = 0 and policy.tempdele = 0
		 order by policyId desc';

        // print_r("<br>".$sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithQuery($query) {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where shippercompanies.tempdele = 0 and policy.tempdele = 0 ' . $query . '
		 order by policyId desc';

        // print_r("<br>".$sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithCompanyIdLimited($start, $end, $companyId) {
        $sql = 'SELECT policy.*, shippercompanies.companyName
		 FROM policy JOIN shippercompanies
		 ON policy.companyId = shippercompanies.companyId
		 where policy.companyId = ' . $companyId . '
		 and  shippercompanies.tempdele = 0 and policy.tempdele = 0
		 order by policyId desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateTempdele($policy) {
        $sql = 'UPDATE policy SET  tempdele = ?  WHERE policyId = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->setNumber($policy->tempdele);

        $sqlQuery->setNumber($policy->policyId);
        return $this->executeUpdate($sqlQuery);
    }

}

?>