<?php

/**
 * Class that operate on table 'productionoutdetails'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:15
 */
class ProductionoutdetailsMySqlExtDAO extends ProductionoutdetailsMySqlDAO {

    public function queryByProductionOutIdEX($value) {
        $sql = 'SELECT productionoutdetails.*,product.productName,productcat.productCatName,size.name as sizeName,color.name as colorName
                ,productunit.productnumber,unit.unitName
                FROM productionoutdetails
                JOIN product	ON product.productId = productionoutdetails.productid
                JOIN productcat ON product.productCatId = productcat.productCatId
                left join sizecolor as size ON size.id=productionoutdetails.sizeid
                left join sizecolor as color ON color.id=productionoutdetails.colorid
                join productunit ON productunit.productunitid=productionoutdetails.unitid
                join unit ON unit.unitId=productunit.unitid
                WHERE productionOutId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($productionoutdetail) {
        $sql = 'INSERT INTO productionoutdetails (id, productionOutId, productid, sizeid, colorid, unitid, price, quantity, inTotalCost) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutdetail->id);
        $sqlQuery->setNumber($productionoutdetail->productionOutId);
        $sqlQuery->setNumber($productionoutdetail->productid);
        $sqlQuery->setNumber($productionoutdetail->sizeid);
        $sqlQuery->setNumber($productionoutdetail->colorid);
        $sqlQuery->setNumber($productionoutdetail->unitid);
        $sqlQuery->set($productionoutdetail->price);
        $sqlQuery->set($productionoutdetail->quantity);
        $sqlQuery->set($productionoutdetail->inTotalCost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutdetail->id = $id;
        return $id;
    }

}

?>