<?php

/**
 * Class that operate on table 'saveclose'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-12-07 03:04
 */
class SavecloseMySqlExtDAO extends SavecloseMySqlDAO
{

    public function queryAllData($queryString = '')
    {
        $sql = 'SELECT saveclose.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM saveclose JOIN save savefrom
		ON saveclose.saveidfrom = savefrom.saveid JOIN save saveto
		ON saveclose.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0   ' . $queryString . '
		order by savecloseid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithQueryString($queryString = '')
    {
        $sql = 'SELECT saveclose.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM saveclose JOIN save savefrom
		ON saveclose.saveidfrom = savefrom.saveid JOIN save saveto
		ON saveclose.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
                ' . $queryString . '
		order by savecloseid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate)
    {
        $sql = 'SELECT saveclose.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM saveclose JOIN save savefrom
		ON saveclose.saveidfrom = savefrom.saveid JOIN save saveto
		ON saveclose.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		and  saveclosedate >= "' . $startDate . '" and saveclosedate <= "' . $endDate . '"
		order by savecloseid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOneDate($condition, $date)
    {
        $sql = 'SELECT saveclose.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM saveclose JOIN save savefrom
		ON saveclose.saveidfrom = savefrom.saveid JOIN save saveto
		ON saveclose.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		and  saveclosedate  ' . $condition . '"' . $date . '"
		order by savecloseid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function loadSaveCloseById($savecloseid)
    {
        $sql = 'SELECT saveclose.*, savefrom.savename as savefromname,
			saveto.savename as savetoname
			FROM saveclose JOIN save savefrom
			ON saveclose.saveidfrom = savefrom.saveid JOIN save saveto
			ON saveclose.saveidto = saveto.saveid
			where savefrom.conditions = 0 and saveto.conditions = 0
			and savecloseid =' . $savecloseid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryWithOrder()
    {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		order by transfermoneyid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateCondition($saveclose)
    {
        $sql = 'UPDATE saveclose SET  saveclosedate = ?, userid = ?, conditions = ? WHERE savecloseid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($saveclose->saveclosedate);
        $sqlQuery->setNumber($saveclose->userid);
        $sqlQuery->setNumber($saveclose->conditions);

        $sqlQuery->setNumber($saveclose->savecloseid);
        return $this->executeUpdate($sqlQuery);
    }
}
