<?php

//the global file operation
include("../public/impOpreation.php");

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Restaurantprinter
require_once('../models/dao/RestaurantprinterDAO.class.php');
require_once('../models/dto/Restaurantprinter.class.php');
require_once('../models/mysql/RestaurantprinterMySqlDAO.class.php');
require_once('../models/mysql/ext/RestaurantprinterMySqlExtDAO.class.php');
//Productcat
require_once('../models/dao/ProductcatDAO.class.php');
require_once('../models/dto/Productcat.class.php');
require_once('../models/mysql/ProductcatMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductcatMySqlExtDAO.class.php');
//Restaurantkitchenprint
require_once('../models/dao/RestaurantkitchenprintDAO.class.php');
require_once('../models/dto/Restaurantkitchenprint.class.php');
require_once('../models/mysql/RestaurantkitchenprintMySqlDAO.class.php');
require_once('../models/mysql/ext/RestaurantkitchenprintMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];
$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");
/* ======================

  Controller Name :- unitController

  OPERTATION in Controller

  1-display add form
  2- add in unit tble
  4-display sucess or error
  5-display show and delete
  6-delete from unit tbl
  7-display edit
  8- update unit tbl
  ======================== */

//here the global templates
$smarty->display("header.html");

//here goes the instances and general variables
//Unit
$restaurantPrinter = new Restaurantprinter();
$restaurantPrinterDAO = new RestaurantprinterMySqlDAO();
$restaurantPrinterEX = new RestaurantprinterMySqlExtDAO();
//
$productCatDAO = new ProductcatMySqlDAO;
$productCatEx = new ProductcatMySqlExtDAO;
//Restaurantkitchenprint
$restaurantkitchenprint = new Restaurantkitchenprint();
$restaurantkitchenprintDAO = new RestaurantkitchenprintMySqlDAO();
$restaurantkitchenprintEX = new RestaurantkitchenprintMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();

//check and use the condition that suite this action
if (empty($do)) {
    //here the permission check
    include_once("../public/authentication.php");
    //here the smarty templates
    $smarty->display("restaurantPrinterView/add.html");
} elseif ($do == "add") {
    include_once("../public/authentication.php");
    try {
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "show") {
    include_once("../public/authentication.php");
    show();

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);
    $smarty->display("restaurantPrinterView/show.html");
} elseif ($do == "delete") {//tempdelete
    include_once("../public/authentication.php");
    $printerId = $_GET['id'];
    try {
        $note = delete($printerId);
        if ($note != "success") {
            $smarty->assign('msgnote', $note);
            $smarty->display("notes.html");
        } else {
            header("location:?do=sucess");
        }
    } catch (Exception $e) {
        //header("location:?do=error");
    }
} elseif ($do == "edit") {//edit  unit
    include_once("../public/authentication.php");
    $data = edit();
    $smarty->assign("data", $data);
    #######
    $cats = $productCatEx->queryAllIn('0'.$data->cats);
    $catsArr = array();
    foreach ($cats as $value) {
        $theCat = new stdClass();
        $theCat->id = $value->productCatId;
        $theCat->text = $value->productCatName;
        array_push($catsArr, $theCat);
    }
    $smarty->assign("cats_hidden", json_encode($catsArr));
    ########
    $smarty->display("restaurantPrinterView/edit.html");
} elseif ($do == "update") { //edit update
    include_once("../public/authentication.php");

    try {
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "resetPrinters") {
    $restaurantkitchenprintEX->resetPrinters();
    echo "done";
} elseif ($do == "sucess") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
}

$smarty->assign("customValidation", 1);

//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

// add in unit tbl
function add() {
    global $restaurantPrinterDAO;
    global $restaurantPrinter;

    $name = $_POST['printerName'];
    $hallPrice = $_POST['hallPrice'];

    //like in expensetypecontroller
    $cats = filter_input(INPUT_POST, 'cats', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);

    $cats_str = '';
    foreach ($cats as $value) {
        $cats_str .= $value . ",";
    }
    $cats_str = rtrim($cats_str, ',');

    $restaurantPrinter->name = $name;
    $restaurantPrinter->cats = $cats_str;
    $restaurantPrinter->userid = $_SESSION['userid'];
    $restaurantPrinter->sysdate = date('Y-m-d');
    $restaurantPrinter->del = 0;
    $restaurantPrinterDAO->insert($restaurantPrinter);
}

//show
function show() {
    global $restaurantPrinterDAO;
    global $restaurantPrinter;
    global $smarty;


    $printersData = $restaurantPrinterDAO->queryAll();
    $smarty->assign('printersData', $printersData);
}

function delete($printerId) {
    global $restaurantPrinterDAO;
    //$deleteFlag;
    if (!empty($printerId)) {
        try {
            //temp delete from unit tbl
            $restaurantPrinterDAO->delete($printerId);
            //$deleteFlag = "true";
            $note = "success";
        } catch (Exception $e) {
            $note = "حدث خطأ أثناء إتمام العملية";
        }
    } else {
        $note = "حدث خطأ أثناء إتمام العملية";
    }
    return $note;
}

function edit() {
    global $restaurantPrinterDAO;

    $id = $_GET['id'];
    $data = $restaurantPrinterDAO->load($id);
    return $data;
}

function update() {
    global $restaurantPrinterDAO;
    global $restaurantPrinter;

    $id = $_POST['id'];
    $name = $_POST['printerName'];
    //like in expensetypecontroller
    $cats = filter_input(INPUT_POST, 'cats', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);

    $cats_str = '';
    foreach ($cats as $value) {
        $cats_str .= $value . ",";
    }
    $cats_str = rtrim($cats_str, ',');

    $restaurantPrinter = $restaurantPrinterDAO->load($id);
    $restaurantPrinter->name = $name;
    $restaurantPrinter->cats = $cats_str;
    $restaurantPrinterDAO->update($restaurantPrinter);
}

?>