<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-07 10:32
 */
interface AssetscatDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Assetscat 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param assetscat primary key
 	 */
	public function delete($assetscatid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Assetscat assetscat
 	 */
	public function insert($assetscat,$Description);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Assetscat assetscat
 	 */
	public function update($assetscat,$Description);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCattitel($value);

	public function queryByUserid($value);

	public function queryByAssetscatdate($value);

	public function queryByDel($value);


	public function deleteByCattitel($value);

	public function deleteByUserid($value);

	public function deleteByAssetscatdate($value);

	public function deleteByDel($value);


}
?>