<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-08-13 04:26
 */
interface AssetssaleDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Assetssale 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param assetssale primary key
 	 */
	public function delete($assetssaleid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Assetssale assetssale
 	 */
	public function insert($assetssale);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Assetssale assetssale
 	 */
	public function update($assetssale);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAssetssaleclient($value);

	public function queryByAssetssalesave($value);

	public function queryByAssetssaleval($value);

	public function queryByAssetssalecomment($value);

	public function queryByAssetssaledateadd($value);

	public function queryByAssetssaledate($value);

	public function queryByAssetsid($value);


	public function deleteByAssetssaleclient($value);

	public function deleteByAssetssalesave($value);

	public function deleteByAssetssaleval($value);

	public function deleteByAssetssalecomment($value);

	public function deleteByAssetssaledateadd($value);

	public function deleteByAssetssaledate($value);

	public function deleteByAssetsid($value);


}
?>