<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BillpropertyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billproperty 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billproperty primary key
 	 */
	public function delete($billpropertyid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billproperty billproperty
 	 */
	public function insert($billproperty,$description);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billproperty billproperty
 	 */
	public function update($billproperty,$description);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillpropertyname($value);

	public function queryByDescription($value);

	public function queryByCondition($value);


	public function deleteByBillpropertyname($value);

	public function deleteByDescription($value);

	public function deleteByCondition($value);


}
?>