<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
interface EmployeedoctordebtandpayDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeedoctordebtandpay 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeedoctordebtandpay primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeedoctordebtandpay employeedoctordebtandpay
 	 */
	public function insert($employeedoctordebtandpay);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeedoctordebtandpay employeedoctordebtandpay
 	 */
	public function update($employeedoctordebtandpay);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByThetype($value);

	public function queryByEmployeeOrDoctor($value);

	public function queryByEmployeeOrDoctorId($value);

	public function queryBySaveid($value);

	public function queryByPaytype($value);

	public function queryByWhatexpens($value);

	public function queryByVal($value);

	public function queryByNote($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByThetype($value);

	public function deleteByEmployeeOrDoctor($value);

	public function deleteByEmployeeOrDoctorId($value);

	public function deleteBySaveid($value);

	public function deleteByPaytype($value);

	public function deleteByWhatexpens($value);

	public function deleteByVal($value);

	public function deleteByNote($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>