<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-03-09 11:49
 */
interface EmployeepersonnelDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeepersonnel 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeepersonnel primary key
 	 */
	public function delete($employeepersonnelid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeepersonnel employeepersonnel
 	 */
	public function insert($employeepersonnel);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeepersonnel employeepersonnel
 	 */
	public function update($employeepersonnel);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeid($value);

	public function queryByEmployeepersonnelvalue($value);

	public function queryByEmployeepersonnelnote($value);

	public function queryByConditions($value);

	public function queryByUserid($value);

	public function queryByEmployeepersonneldate($value);

	public function queryByEmployeepersonneltype($value);


	public function deleteByEmployeeid($value);

	public function deleteByEmployeepersonnelvalue($value);

	public function deleteByEmployeepersonnelnote($value);

	public function deleteByConditions($value);

	public function deleteByUserid($value);

	public function deleteByEmployeepersonneldate($value);

	public function deleteByEmployeepersonneltype($value);


}
?>