<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface ExpensetypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Expensetype 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param expensetype primary key
 	 */
	public function delete($expensetypeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Expensetype expensetype
 	 */
	public function insert($expensetype);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Expensetype expensetype
 	 */
	public function update($expensetype);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExpensetypename($value);

	public function queryByExpensetypecomment($value);

	public function queryByTempdelete($value);


	public function deleteByExpensetypename($value);

	public function deleteByExpensetypecomment($value);

	public function deleteByTempdelete($value);


}
?>