<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-09-12 16:51
 */
interface FaidaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Faida 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param faida primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Faida faida
 	 */
	public function insert($faida);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Faida faida
 	 */
	public function update($faida);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByProductId($value);

	public function queryByPremmium($value);

	public function queryByComment($value);


	public function deleteByClientId($value);

	public function deleteByProductId($value);

	public function deleteByPremmium($value);

	public function deleteByComment($value);


}
?>