<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MProducthistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MProducthistory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mProducthistory primary key
 	 */
	public function delete($productHistoryId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MProducthistory mProducthistory
 	 */
	public function insert($mProducthistory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MProducthistory mProducthistory
 	 */
	public function update($mProducthistory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOurSerial($value);

	public function queryByStageFrom($value);

	public function queryByStageTo($value);

	public function queryByComment($value);

	public function queryByStatus($value);

	public function queryByUserId($value);

	public function queryByProductHistoryDate($value);

	public function queryByBranchId($value);

	public function queryByDel($value);


	public function deleteByOurSerial($value);

	public function deleteByStageFrom($value);

	public function deleteByStageTo($value);

	public function deleteByComment($value);

	public function deleteByStatus($value);

	public function deleteByUserId($value);

	public function deleteByProductHistoryDate($value);

	public function deleteByBranchId($value);

	public function deleteByDel($value);


}
?>