<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:16
 */
interface PlaystationcardDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Playstationcard 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param playstationcard primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Playstationcard playstationcard
 	 */
	public function insert($playstationcard);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Playstationcard playstationcard
 	 */
	public function update($playstationcard);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByPackageVal($value);

	public function queryByPackagePrice($value);

	public function queryByPackageDays($value);

	public function queryByFile($value);

	public function queryByDel($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);


	public function deleteByName($value);

	public function deleteByPackageVal($value);

	public function deleteByPackagePrice($value);

	public function deleteByPackageDays($value);

	public function deleteByFile($value);

	public function deleteByDel($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);


}
?>