<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 10:51
 */
interface PolicyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Policy 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param policy primary key
 	 */
	public function delete($policyId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Policy policy
 	 */
	public function insert($policy);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Policy policy
 	 */
	public function update($policy);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPolicyName($value);

	public function queryByPolicyDate($value);

	public function queryByPolicyNum($value);

	public function queryByPolicyCost($value);

	public function queryByPolicyType($value);

	public function queryByCompanyId($value);

	public function queryBySenderName($value);


	public function deleteByPolicyName($value);

	public function deleteByPolicyDate($value);

	public function deleteByPolicyNum($value);

	public function deleteByPolicyCost($value);

	public function deleteByPolicyType($value);

	public function deleteByCompanyId($value);

	public function deleteBySenderName($value);


}
?>