<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-17 14:11
 */
interface ProductsettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productsetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productsetting primary key
 	 */
	public function delete($productsettingid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productsetting productsetting
 	 */
	public function insert($productsetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productsetting productsetting
 	 */
	public function update($productsetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByLeastValueAtStore($value);

	public function queryByStoreid($value);


	public function deleteByLeastValueAtStore($value);

	public function deleteByStoreid($value);


}
?>