<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
interface QuickprofitdayDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Quickprofitday 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param quickprofitday primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Quickprofitday quickprofitday
 	 */
	public function insert($quickprofitday);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Quickprofitday quickprofitday
 	 */
	public function update($quickprofitday);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTheDate($value);

	public function queryBySellVal($value);

	public function queryBySellCostBuyPrice($value);

	public function queryBySellCostLastBuyPrice($value);

	public function queryBySellCostMeanBuyPrice($value);

	public function queryBySellCostLastBuyPricewithDiscount($value);

	public function queryBySellCostMeanBuyPricewithDiscount($value);

	public function queryByReturnSellVal($value);

	public function queryByReturnSellCostBuyPrice($value);

	public function queryByReturnSellCostLastBuyPrice($value);

	public function queryByReturnSellCostMeanBuyPrice($value);

	public function queryByReturnSellCostLastBuyPricewithDiscount($value);

	public function queryByReturnSellCostMeanBuyPricewithDiscount($value);


	public function deleteByTheDate($value);

	public function deleteBySellVal($value);

	public function deleteBySellCostBuyPrice($value);

	public function deleteBySellCostLastBuyPrice($value);

	public function deleteBySellCostMeanBuyPrice($value);

	public function deleteBySellCostLastBuyPricewithDiscount($value);

	public function deleteBySellCostMeanBuyPricewithDiscount($value);

	public function deleteByReturnSellVal($value);

	public function deleteByReturnSellCostBuyPrice($value);

	public function deleteByReturnSellCostLastBuyPrice($value);

	public function deleteByReturnSellCostMeanBuyPrice($value);

	public function deleteByReturnSellCostLastBuyPricewithDiscount($value);

	public function deleteByReturnSellCostMeanBuyPricewithDiscount($value);


}
?>